import 'package:absenkuv3/Repository/Model/SalesActivity/mDailyActivity.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mDetailKanbanBoard.dart';
import 'package:absenkuv3/Repository/Service/SalesActivityApi.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class DetailKanbanSalesEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getDataDetailKanbanSalesEvent extends DetailKanbanSalesEvent {
  String? idPipelineMain;
  String? idPipelineMainLog;
  getDataDetailKanbanSalesEvent(BuildContext _context, this.idPipelineMain, this.idPipelineMainLog) {
    context = _context;
  }
}

abstract class DetailKanbanSalesState {
  DetailDataKanban? data;
}

class getDetailKanbanSalesSuccessState extends DetailKanbanSalesState {
  getDetailKanbanSalesSuccessState(DetailKanbanSalesEvent _event, DetailDataKanban? _data) {
    data = _data;
  }
}

class DetailKanbanSalesProgressState extends DetailKanbanSalesState {}

class DetailKanbanSalesErrorState extends DetailKanbanSalesState {}

class DetailKanbanSalesEmptyState extends DetailKanbanSalesState {}

class DetailKanbanSalesBloc extends Bloc<DetailKanbanSalesEvent, DetailKanbanSalesState> {
  DetailKanbanSalesState? initialState;
  DetailDataKanban? dataDetailKanban;

  DetailKanbanSalesBloc(DetailKanbanSalesState initialState) : super(initialState);

  @override
  Stream<DetailKanbanSalesState> mapEventToState(DetailKanbanSalesEvent event) async* {
    if (event is getDataDetailKanbanSalesEvent) {
      yield DetailKanbanSalesProgressState();
      DetailKanbanBoardRespon dataAktivitasSalesRespon = await SalesActivityApi().getDetailDataKanban(event.idPipelineMain, event.idPipelineMainLog);
      if (dataAktivitasSalesRespon.success!) {
        dataDetailKanban = dataAktivitasSalesRespon.detailDataKanban;
        yield getDetailKanbanSalesSuccessState(event, dataDetailKanban);
      } else if(!dataAktivitasSalesRespon.success!)
        yield DetailKanbanSalesEmptyState();
      else yield DetailKanbanSalesErrorState();
    }
  }
}
