import 'package:absenkuv3/Repository/Model/SalesActivity/mDataLayanan.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mDataLayananDetail.dart';
import 'package:absenkuv3/Repository/Service/SalesActivityApi.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class DataLayananDetailEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getDataLayananDetailEvent extends DataLayananDetailEvent {
  String? idPipelineMain;
  getDataLayananDetailEvent(BuildContext _context, this.idPipelineMain) {
    context = _context;
  }
}

abstract class DataLayananDetailState {
  List<Layanan>? dataLayananDetail;
}

class getDataLayananDetailSuccessState extends DataLayananDetailState {
  getDataLayananDetailSuccessState(List<Layanan> _dataTotal) {
    dataLayananDetail = _dataTotal;
  }
}

class loadMoreEvent extends DataLayananDetailEvent {
  late ScrollController scrollController;
  late String idPipelineMain;
  loadMoreEvent(BuildContext _context, ScrollController _scrollController, String _idPipelineMain) {
    context = _context;
    scrollController = _scrollController;
    idPipelineMain = _idPipelineMain;
  }
}

class LoadMoreProgressState extends DataLayananDetailState {
  LoadMoreProgressState(List<Layanan>? _data) {
    dataLayananDetail = _data;
  }
}

class DataLayananDetailProgressState extends DataLayananDetailState {}

class DataLayananDetailErrorState extends DataLayananDetailState {}

class DataLayananDetailBloc extends Bloc<DataLayananDetailEvent, DataLayananDetailState> {
  List<Layanan>? dataLayananDetail;
  int offset = 0;
  int limit = ServerInfo.limit;

  DataLayananDetailBloc(DataLayananDetailState initialState) : super(initialState);

  @override
  Stream<DataLayananDetailState> mapEventToState(DataLayananDetailEvent event) async* {
    if (event is getDataLayananDetailEvent) {
      offset = 0;
      yield DataLayananDetailProgressState();
      DataLayananDetailRespon _dataLayananDetail = await SalesActivityApi().getDataLayananDetail(event.idPipelineMain, offset);
      if (_dataLayananDetail.success!) {
        dataLayananDetail = _dataLayananDetail.dataLayananDetail;
        yield getDataLayananDetailSuccessState(dataLayananDetail!);
      } else
        yield DataLayananDetailErrorState();
    }
    else if (event is loadMoreEvent) {
      if (event.scrollController.offset >= event.scrollController.position.maxScrollExtent && !event.scrollController.position.outOfRange) {
        offset = offset + limit;
        yield LoadMoreProgressState(dataLayananDetail);
        DataLayananDetailRespon _dataLayananDetail = await SalesActivityApi().getDataLayananDetail(event.idPipelineMain, offset);
        if (_dataLayananDetail.success!) {
          dataLayananDetail!.addAll(_dataLayananDetail.dataLayananDetail!);
        }
        yield getDataLayananDetailSuccessState(dataLayananDetail!);
      }
    }
  }
}
