import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mReimbursement.dart';
import 'package:absenkuv3/Repository/Service/reimbursementApi.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';

abstract class RekapReimbursementSayaEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class GetListReimbursementEvent extends RekapReimbursementSayaEvent {
  ModelFilter? modelFilter;
  GetListReimbursementEvent(BuildContext _context, this.modelFilter) {
    context = _context;
  }
}

class LoadMoreEvent extends RekapReimbursementSayaEvent {
  late ScrollController scrollController;
  LoadMoreEvent(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey,
      ScrollController _scrollController) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    scrollController = _scrollController;
  }
}

abstract class RekapReimbursementSayaState {
  List<DataReimbursement>? data;
  DataReimbursement? dataReimbusement;
}

class GetListReimbursementSuccessState extends RekapReimbursementSayaState {
  GetListReimbursementSuccessState(
      RekapReimbursementSayaEvent _event, List<DataReimbursement>? _data) {
    data = _data;
  }
}

class ReimbursementProgressState extends RekapReimbursementSayaState {}

class LoadMoreProgressState extends RekapReimbursementSayaState {
  LoadMoreProgressState(List<DataReimbursement>? _data) {
    data = _data;
  }
}

class ReimbursementErrorState extends RekapReimbursementSayaState {}

class RekapReimbursementSayaBloc
    extends Bloc<RekapReimbursementSayaEvent, RekapReimbursementSayaState> {
  final dateFormat = new DateFormat('yyyy-MM');
  RekapReimbursementSayaState? initialState;
  List<DataReimbursement>? listReimbursement;
  ModelFilter? modelFilter;
  int offset = 0;
  int limit = ServerInfo.limit;

  RekapReimbursementSayaBloc(RekapReimbursementSayaState initialState)
      : super(initialState);

  @override
  Stream<RekapReimbursementSayaState> mapEventToState(
      RekapReimbursementSayaEvent event) async* {
    if (event is GetListReimbursementEvent) {
      offset = 0;
      modelFilter = event.modelFilter;
      yield ReimbursementProgressState();
      ReimbursementRespon reimbursementRespon = await ReimbursementApi()
          .getDataRekapReimbursementSaya(modelFilter, offset);
      if (reimbursementRespon.success!) {
        listReimbursement = reimbursementRespon.data;
        yield GetListReimbursementSuccessState(event, listReimbursement);
      } else
        yield ReimbursementErrorState();
    } else if (event is LoadMoreEvent) {
      if (event.scrollController.offset >=
              event.scrollController.position.maxScrollExtent &&
          !event.scrollController.position.outOfRange) {
        offset = offset + limit;
        yield LoadMoreProgressState(listReimbursement);
        ReimbursementRespon reimbursementRespon = await ReimbursementApi()
            .getDataRekapReimbursementSaya(modelFilter, offset);
        if (reimbursementRespon.success!) {
          listReimbursement!.addAll(reimbursementRespon.data!);
        }
        yield GetListReimbursementSuccessState(event, listReimbursement);
      }
    }
  }
}
