import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Bloc/Pkwt/DataCallbackPkwtBloc.dart';
import 'package:absenkuv3/Bloc/Pkwt/DetailPkwtBloc.dart';
import 'package:absenkuv3/Repository/Model/mPkwt.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/pkwtApi.dart';
import 'package:absenkuv3/UI/Template/Snackbar/CustomSnackbar.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:sn_progress_dialog/progress_dialog.dart';

abstract class PkwtEvent {
  BuildContext? context;
  String? eventName;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class tolakPwtEvent extends PkwtEvent {
  GlobalKey<ScaffoldState>? scaffoldKey;
  BuildContext? context;
  TolakPkwtModel tolakPkwtModel;
  tolakPwtEvent(
      _context, GlobalKey<ScaffoldState> _scaffoldKey, this.tolakPkwtModel) {
    context = _context;
    scaffoldKey = _scaffoldKey;
  }
}

class setujuiPkwt extends PkwtEvent {
  GlobalKey<ScaffoldState>? scaffoldKey;
  BuildContext? context;
  SetujuiPkwtModel setujuiPkwtModel;
  setujuiPkwt(
      _context, GlobalKey<ScaffoldState> _scaffoldKey, this.setujuiPkwtModel) {
    context = _context;
    scaffoldKey = _scaffoldKey;
  }
}

class getListPkwtEvent extends PkwtEvent {
  getListPkwtEvent(BuildContext? _context, String _eventName) {
    context = _context;
    eventName = _eventName;
  }
}

class ChangePkwtStatusEvent extends PkwtEvent {
  final int index;
  final String status;
  final String warnaFont;
  final String warnaStatus;

  ChangePkwtStatusEvent({
    required this.index,
    required this.status,
    required this.warnaFont,
    required this.warnaStatus,
  });
}

abstract class PkwtState {
  List<DataPkwt>? data;
  String? blocEvent;
}

class getListPkwtSuccessState extends PkwtState {
  getListPkwtSuccessState(
      PkwtEvent _event, List<DataPkwt>? _data, String _blocEvent) {
    data = _data;
    blocEvent = _blocEvent;
  }
}

class PkwtProgressState extends PkwtState {}

class PkwtErrorState extends PkwtState {}

class PkwtBloc extends Bloc<PkwtEvent, PkwtState> {
  PkwtState? initialState;
  List<DataPkwt>? listPkwt;
  PkwtBloc(PkwtState initialState) : super(initialState);
  @override
  Stream<PkwtState> mapEventToState(PkwtEvent event) async* {
    if (event is getListPkwtEvent) {
      yield PkwtProgressState();
      PkwtRespon pkwtRespon = await PkwtApi().getDataPkwt('pkwtSaya');
      if (pkwtRespon.success!) {
        listPkwt = pkwtRespon.data;
        yield getListPkwtSuccessState(event, listPkwt, event.eventName!);
      } else
        yield PkwtErrorState();
    } else if (event is ChangePkwtStatusEvent) {
      if (state is getListPkwtSuccessState) {
        final updatedList = List<DataPkwt>.from(state.data ?? []);
        updatedList.forEach((item) {
          print(item.status); // Assuming DataPkwt has a toMap method
        });
        updatedList[event.index] = updatedList[event.index].copyWith(
          status: event.status,
          warnaFont: event.warnaFont,
          warnaStatus: event.warnaStatus,
        );
        updatedList.forEach((item) {
          print(item.status); // Assuming DataPkwt has a toMap method
        });
        yield getListPkwtSuccessState(event, updatedList, 'statusUpdated');
      }
    } else if (event is tolakPwtEvent) {
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd, isDismissible: false);
      BasicRespon basicRespon = await PkwtApi().tolakPwkt(event.tolakPkwtModel);
      CustomSnackBar.show(
          event.context!, basicRespon.message!, SnackBarType.success);
      ProgressDialogDelayed.hide(pd);
      if (basicRespon.success!) {
        event.context!
            .read<DataCallbackPkwtCubit>()
            .updateDataCallback([true, 'tolak']);
        Future.delayed(Duration(milliseconds: 500)).then((value) {
          BlocProvider.of<NavigatorBloc>(event.context!)
              .add(NavigatePop(event.context));
          BlocProvider.of<DetailPkwtBloc>(event.context!)
              .add(GetDetailPkwt(event.tolakPkwtModel.id_pkwt));
          // BlocProvider.of<PkwtBloc>(event.context!)
          //     .add(getListPkwtEvent(event.context, 'tolak'));
          // event.context!
          //     .read<DataCallbackPkwtCubit>()
          //     .updateDataCallback([true,'tolak']);
        });
      }
    } else if (event is setujuiPkwt) {
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd, isDismissible: false);
      BasicRespon basicRespon =
          await PkwtApi().setujuiPkwt(event.setujuiPkwtModel);
      CustomSnackBar.show(
          event.context!, basicRespon.message!, SnackBarType.success);
      ProgressDialogDelayed.hide(pd);
      if (basicRespon.success!) {
        event.context!
            .read<DataCallbackPkwtCubit>()
            .updateDataCallback([true, 'setujui']);
        Future.delayed(Duration(milliseconds: 500)).then((value) {
          BlocProvider.of<NavigatorBloc>(event.context!)
              .add(NavigatePop(event.context));
          BlocProvider.of<DetailPkwtBloc>(event.context!)
              .add(GetDetailPkwt(event.setujuiPkwtModel.id_pkwt));
          // BlocProvider.of<PkwtBloc>(event.context!)
          //     .add(getListPkwtEvent(event.context, 'setujui'));
        });
      }
    }
  }
}
