import 'package:absenkuv3/Repository/Model/MonitorAbsen/mMonitorAbsen.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Service/MonitorAbsensi/monitorAbsenApi.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class MonitorListIzinEvent {
  BuildContext? context;
  String? konteks;
}

abstract class MonitorListIzinMonitorState {
  List<DataMonitorAbsen>? dataMonitorList;
}

class GetMonitorListIzinEvent extends MonitorListIzinEvent {
  ModelFilter? modelFilter;
  GetMonitorListIzinEvent(BuildContext _context, String _konteks,this.modelFilter) {
    context = _context;
    konteks = _konteks;
  }
}

class loadMoreEvent extends MonitorListIzinEvent {
  late ScrollController scrollController;
  loadMoreEvent(ScrollController _scrollController, String _konteks) {
    scrollController = _scrollController;
    konteks = _konteks;
  }
}

class LoadMoreProgressState extends MonitorListIzinMonitorState {
  LoadMoreProgressState(List<DataMonitorAbsen>? _data) {
    dataMonitorList = _data;
  }
}

class SuccessMonitorListIzinMonitorState extends MonitorListIzinMonitorState {
  SuccessMonitorListIzinMonitorState(List<DataMonitorAbsen>? _dataMonitorList) {
    dataMonitorList = _dataMonitorList;
  }
}

class ProgressMonitorListIzinMonitorState extends MonitorListIzinMonitorState {}

class ErrorMonitorIzinState extends MonitorListIzinMonitorState {}

class MonitorListIzinBloc extends Bloc<MonitorListIzinEvent, MonitorListIzinMonitorState> {
  MonitorListIzinBloc(MonitorListIzinMonitorState initialState) : super(initialState);
  List<DataMonitorAbsen>? dataMonitorList;
  int offset = 0;
  int limit = ServerInfo.limit;
  ModelFilter? modelFilter;
  @override
  Stream<MonitorListIzinMonitorState> mapEventToState(MonitorListIzinEvent event) async* {
    if (event is GetMonitorListIzinEvent) {
      offset = 0;
      debugPrint(event.konteks! + ' konteks');
      debugPrint(offset.toString());
      modelFilter = event.modelFilter;
      yield ProgressMonitorListIzinMonitorState();
      MonitorabsensiRespon data = await MonitorAbsenApi()
          .getDataListIzinMonitor(modelFilter,event.konteks!, offset);
      if (data.success!) {
        dataMonitorList = data.data;
        yield SuccessMonitorListIzinMonitorState(dataMonitorList);
      } else {
        yield ErrorMonitorIzinState();
      }
    } else if (event is loadMoreEvent) {
      if (event.scrollController.offset >=
          event.scrollController.position.maxScrollExtent &&
          !event.scrollController.position.outOfRange) {
        offset = offset + limit;
        yield LoadMoreProgressState(dataMonitorList);
        MonitorabsensiRespon data = await MonitorAbsenApi()
            .getDataListIzinMonitor(modelFilter,event.konteks!, offset);
        if (data.success!) {
          dataMonitorList!.addAll(data.data!);
        }
        yield SuccessMonitorListIzinMonitorState(dataMonitorList);
      }
    }
  }
}
