import 'package:absenkuv3/Repository/Model/mLembur.dart';
import 'package:absenkuv3/Repository/Service/lemburApi.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class DetailLemburEvent {}

class GetDetailLembur extends DetailLemburEvent {
  String? id;
  String konteks;
  GetDetailLembur(this.id, this.konteks);
}

abstract class DetailLemburState {}

class DetailLemburProgress extends DetailLemburState {}

class DetailLemburSuccess extends DetailLemburState {
  LemburRespon? lemburRespon;
  DetailLemburSuccess(this.lemburRespon);
}

class DetailLemburError extends DetailLemburState {}

class DetailLemburBloc extends Bloc<DetailLemburEvent, DetailLemburState> {
  LemburRespon? lemburRespon;

  DetailLemburBloc(DetailLemburState initialState) : super(initialState);

  @override
  Stream<DetailLemburState> mapEventToState(DetailLemburEvent event) async* {
    if (event is GetDetailLembur) {
      yield DetailLemburProgress();
      if (event.konteks == 'rekapPegawai' || event.konteks == 'rekapSaya')
        lemburRespon = await LemburApi().getDataRekapLemburDetail(event.id);
      else
        lemburRespon =
            await LemburApi().getDataLemburDetail(event.id, 'lemburDetail');
      if (lemburRespon!.success!)
        yield DetailLemburSuccess(lemburRespon);
      else
        yield DetailLemburError();
    }
  }
}
