import 'package:absenkuv3/Repository/Model/Kpi/Core/mFilterKpi.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiTeam/mGetDataKpi.dart';
import 'package:absenkuv3/Repository/Service/kpiApi.dart';
import 'package:bloc/bloc.dart';

abstract class GetListKpiEvent {}

class GetDataListKpi extends GetListKpiEvent {
  ModelFilterKpi? modelFilter;
  GetDataListKpi(this.modelFilter);
}



abstract class DataListKpiState {
  List<DataKpi>? data;
}

class DataListKpiProgressState extends DataListKpiState {}

class GetListKpiSuccessState extends DataListKpiState {
  GetListKpiSuccessState(List<DataKpi>? _data) {
    data = _data;
  }
}


class ListKpiErrorState extends DataListKpiState {}

class GetListKpiBloc
    extends Bloc<GetListKpiEvent, DataListKpiState> {
  ResponlistKpi? dataRespon;
  List<DataKpi>? listDataKpi;

  GetListKpiBloc(DataListKpiState initialState) : super(initialState);

  @override
  Stream<DataListKpiState> mapEventToState(
      GetListKpiEvent event) async* {
    if (event is GetDataListKpi) {
      yield DataListKpiProgressState();
      dataRespon = await KpiApi().getListKpi(event.modelFilter!);
      if (dataRespon!.success!) {
        listDataKpi = dataRespon!.data;
        yield GetListKpiSuccessState(listDataKpi);
      } else {
        yield ListKpiErrorState();
      }
    }
  }
}
