import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/Bloc/Kpi/KpiSaya/GetListKpiSayaBloc.dart';
import 'package:absenkuv3/Bloc/Kpi/KpiTeam/GetListKpiTeamBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/Kpi/Core/mFilterKpi.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiTeam/mDataPengajuanKpi.dart' as mPengajuanKpi;
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/kpiApi.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:sn_progress_dialog/sn_progress_dialog.dart';

abstract class SimpanDraftPengajuanKpiSayaEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class SimpanDraftPengajuanKpiSaya extends SimpanDraftPengajuanKpiSayaEvent {
  mPengajuanKpi.ParsingModelKaryawan karyawan;
  List<Map<String, dynamic>> listItem;
  BuildContext? context;
  SimpanDraftPengajuanKpiSaya(this.listItem, this.karyawan, this.context);
}

class SimpanDraftPengajuanApproval extends SimpanDraftPengajuanKpiSayaEvent {
  List<Map<String, dynamic>> listItem;
  mPengajuanKpi.ParsingModelKaryawan karyawan;
  BuildContext? context;
  SimpanDraftPengajuanApproval(this.listItem, this.karyawan, this.context);
}

class SimpanDraftPengajuanAspekKepribadian
    extends SimpanDraftPengajuanKpiSayaEvent {
  List<Map<String, dynamic>> listItem;
  mPengajuanKpi.ParsingModelKaryawan dataKaryawan;
  BuildContext? context;
  SimpanDraftPengajuanAspekKepribadian(
      this.listItem, this.dataKaryawan, this.context);
}

class PublishKeAtasan extends SimpanDraftPengajuanKpiSayaEvent {
  List<Map<String, dynamic>> listItem;
  mPengajuanKpi.ParsingModelKaryawan dataKaryawan;
  BuildContext? context;
  PublishKeAtasan(this.listItem, this.dataKaryawan, this.context);
}

abstract class SimpanPengajuanDraftKpiSayaState {}

class SimpanPengajuanDraftKpiSayaProgress
    extends SimpanPengajuanDraftKpiSayaState {}

class SimpanPengajuanDraftKpiSayaKpiError
    extends SimpanPengajuanDraftKpiSayaState {}

class SimpanDraftPengajuanKpiSayaBloc extends Bloc<
    SimpanDraftPengajuanKpiSayaEvent, SimpanPengajuanDraftKpiSayaState> {
  SimpanDraftPengajuanKpiSayaBloc(SimpanPengajuanDraftKpiSayaState initialState)
      : super(initialState);

  @override
  Stream<SimpanPengajuanDraftKpiSayaState> mapEventToState(
      SimpanDraftPengajuanKpiSayaEvent event) async* {
    if (event is SimpanDraftPengajuanKpiSaya) {
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon = await KpiApi()
          .simpanDataPengajuanDraftSaya(event.listItem, event.karyawan);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(
          event.scaffoldKey, basicRespon.message, event.context);
      if (basicRespon.success!) {
        if (basicRespon.success == true) {
          BlocProvider.of<NavigatorBloc>(event.context!)
              .add(NavigatePop(event.context));
          BlocProvider.of<GetListKpiSayaBloc>(event.context!)
              .add(GetDataListKpiSaya(ModelFilterKpi(status: '6,7')));
        }
      }
    } else if (event is SimpanDraftPengajuanApproval) {
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon = await KpiApi()
          .simpanDataPengajuanDraftApproval(event.listItem, event.karyawan);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(
          event.scaffoldKey, basicRespon.message, event.context);
      if (basicRespon.success!) {
        if (basicRespon.success == true) {
          BlocProvider.of<GetDataListKpiPengajuanTeamBloc>(event.context!)
              .add(GetDataListKpiPengajuanTeam(ModelFilterKpi(status: '1,8')));
          // BlocProvider.of<NavigatorBloc>(event.context!)
          //     .add(NavigatePop(event.context));
        }
      }
    } else if (event is SimpanDraftPengajuanAspekKepribadian) {
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon = await KpiApi()
          .simpanDataPengajuanDraftAspekKepribadian(
              event.listItem, event.dataKaryawan);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(
          event.scaffoldKey, basicRespon.message, event.context);
      if (basicRespon.success!) {
        if (basicRespon.success == true) {
          BlocProvider.of<GetDataListKpiPengajuanTeamBloc>(event.context!)
              .add(GetDataListKpiPengajuanTeam(ModelFilterKpi(status: '1,8')));
        }
      }
    } else if (event is PublishKeAtasan) {
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon =
          await KpiApi().publishAtasan(event.listItem, event.dataKaryawan);
      ProgressDialogDelayed.hide(pd);
      // showToastMessageError(
      //     context: event.context, message: basicRespon.message);
      showSnackBarDelayed(
          event.scaffoldKey, basicRespon.message, event.context);
      if (basicRespon.success!) {
        if (basicRespon.success == true) {
          BlocProvider.of<NavigatorBloc>(event.context!)
              .add(NavigatePop(event.context));
          BlocProvider.of<GetListKpiSayaBloc>(event.context!)
              .add(GetDataListKpiSaya(ModelFilterKpi(status: '6,7')));
        }
      }
    }
  }
}
