import 'package:absenkuv3/Repository/Model/Kpi/Core/mGetKomponenAtasan.dart';
import 'package:absenkuv3/Repository/Service/kpiApi.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class GetKomponenAtasanEvent {}

class GetDataKomponenAtasan extends GetKomponenAtasanEvent {
  GetDataKomponenAtasan();
}

abstract class DataKomponenAtasanState {}

class DataKomponenAtasanProgress extends DataKomponenAtasanState {}

class DataKomponenAtasanSuccess extends DataKomponenAtasanState {
  GetKomponenAtasanRespon respon;
  DataKomponenAtasanSuccess(this.respon);
}

class DataAtasanError extends DataKomponenAtasanState {}

class GetKomponenAtasanBloc
    extends Bloc<GetKomponenAtasanEvent, DataKomponenAtasanState> {
  GetKomponenAtasanBloc(DataKomponenAtasanState initialState)
      : super(initialState);

  @override
  Stream<DataKomponenAtasanState> mapEventToState(
      GetKomponenAtasanEvent event) async* {
    if (event is GetDataKomponenAtasan) {
      yield DataKomponenAtasanProgress();
      GetKomponenAtasanRespon respon = await KpiApi().getKomponenAtasan();
      if (respon.success!)
        yield DataKomponenAtasanSuccess(respon);
      else
        yield DataAtasanError();
    }
  }
}
