import 'package:absenkuv3/Repository/Model/MonitorAbsen/mMonitorAbsen.dart';
import 'package:absenkuv3/Repository/Service/koordinatorApi.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class MonitorAbsenKlienEvent {
  BuildContext? context;
  String? konteks;
  String? limit;
  String? idKlien;
}

abstract class MonitorAbsenKlienState {
  List<DataMonitorAbsen>? dataMonitorAbsen;
  String? jenis_data;
}

class GetMonitorAbsenKlienEvent extends MonitorAbsenKlienEvent {
  GetMonitorAbsenKlienEvent(
      BuildContext _context, String _konteks, String _limit,String _idKlien) {
    context = _context;
    konteks = _konteks;
    limit = _limit;
    idKlien = _idKlien;
  }
}

class loadMoreEvent extends MonitorAbsenKlienEvent {
  late ScrollController scrollController;
  loadMoreEvent(
      ScrollController _scrollController, String _konteks, String _limit, String _idKlien) {
    scrollController = _scrollController;
    konteks = _konteks;
    limit = _limit;
    idKlien = _idKlien;
  }
}

class LoadMoreProgressState extends MonitorAbsenKlienState {
  LoadMoreProgressState(List<DataMonitorAbsen>? _data) {
    dataMonitorAbsen = _data;
  }
}

class SuccessMonitorAbsenKlienState extends MonitorAbsenKlienState {
  SuccessMonitorAbsenKlienState(
      List<DataMonitorAbsen>? _dataMonitorAbsen, String _jenis_data) {
    dataMonitorAbsen = _dataMonitorAbsen;
    jenis_data = _jenis_data;
  }
}

class ProgressMonitorAbsenKlienState extends MonitorAbsenKlienState {}

class ErrorMonitorAbsenKlienState extends MonitorAbsenKlienState {}

class MonitorAbsenKlienBloc
    extends Bloc<MonitorAbsenKlienEvent, MonitorAbsenKlienState> {
  MonitorAbsenKlienBloc(MonitorAbsenKlienState initialState)
      : super(initialState);
  List<DataMonitorAbsen>? dataMonitorAbsen;
  String? jenis_data;
  int offset = 0;
  int limit = ServerInfo.limit;
  @override
  Stream<MonitorAbsenKlienState> mapEventToState(
      MonitorAbsenKlienEvent event) async* {
    if (event is GetMonitorAbsenKlienEvent) {
      offset = 0;
      debugPrint(event.konteks! + ' konteks');
      debugPrint(offset.toString());
      yield ProgressMonitorAbsenKlienState();
      MonitorabsensiRespon data = await KoordinatorApi()
          .getDataMonitorAbsen(event.konteks!, offset, event.limit!,event.idKlien!);
      if (data.success!) {
        dataMonitorAbsen = data.data;
        jenis_data = data.jenis_data;
        yield SuccessMonitorAbsenKlienState(dataMonitorAbsen, jenis_data!);
      } else {
        yield ErrorMonitorAbsenKlienState();
      }
    } else if (event is loadMoreEvent) {
      if (event.scrollController.offset >=
              event.scrollController.position.maxScrollExtent &&
          !event.scrollController.position.outOfRange) {
        offset = offset + limit;
        yield LoadMoreProgressState(dataMonitorAbsen);
        MonitorabsensiRespon data = await KoordinatorApi()
            .getDataMonitorAbsen(event.konteks!, offset, event.limit!, event.idKlien!);
        if (data.success!) {
          dataMonitorAbsen!.addAll(data.data!);
          jenis_data = jenis_data;
        }
        yield SuccessMonitorAbsenKlienState(dataMonitorAbsen, jenis_data!);
      }
    }
  }
}
