import 'package:absenkuv3/Repository/Model/MonitorAbsen/mBadgeMonitorAbsen.dart';
import 'package:absenkuv3/Repository/Service/koordinatorApi.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class BadgeMonitorAbsenKlienEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
  String? idKlien;
}

abstract class BadgeMonitorAbsenKlienState {}

class GetBadgeMonitorAbsen extends BadgeMonitorAbsenKlienEvent {
  GetBadgeMonitorAbsen(
    BuildContext _context,
    String _idKlien,
  ) {
    context = _context;
    idKlien = _idKlien;
  }
}

class GetSuccessBadgeMonitor extends BadgeMonitorAbsenKlienState {
  BadgeMonitorAbsen? dataColumn;
  GetSuccessBadgeMonitor(this.dataColumn) {}
}

class GetBadgeMonitorKlienProgress extends BadgeMonitorAbsenKlienState {}

class GetFailed extends BadgeMonitorAbsenKlienState {}

class BadgeMonitorAbsenKlienBloc
    extends Bloc<BadgeMonitorAbsenKlienEvent, BadgeMonitorAbsenKlienState> {
  BadgeMonitorAbsenKlienBloc(BadgeMonitorAbsenKlienState initialState)
      : super(initialState);

  @override
  Stream<BadgeMonitorAbsenKlienState> mapEventToState(
      BadgeMonitorAbsenKlienEvent event) async* {
    if (event is GetBadgeMonitorAbsen) {
      BadgeMonitorAbsen dashboardRespon =
          await KoordinatorApi().badgeMonitorAbsen(event.idKlien);
      if (dashboardRespon.success!)
        yield GetSuccessBadgeMonitor(dashboardRespon);
      else
        yield GetFailed();
    }
  }
}
