import 'package:absenkuv3/Repository/Model/mAktivitas.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Service/aktivitasApi.dart';
import 'package:absenkuv3/Repository/Service/koordinatorApi.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class AktivitasKlienEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getListAktivitasKlienEvent extends AktivitasKlienEvent {
  ModelFilter? modelFilter;
  String? idKlien;
  getListAktivitasKlienEvent(
      BuildContext? _context, this.modelFilter, String idKlien_) {
    context = _context;
    idKlien = idKlien_;
  }
}

class loadMoreEvent extends AktivitasKlienEvent {
  late ScrollController scrollController;
  String? idKlien;
  loadMoreEvent(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey,
      ScrollController _scrollController, String idKlien_) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    scrollController = _scrollController;
    idKlien = idKlien_;
  }
}

abstract class AktivitasKlienState {
  List<DataAktivitas>? data;
  DataAktivitas? dataAktivitas;
}

class getListAktivitasSuccessState extends AktivitasKlienState {
  getListAktivitasSuccessState(
      AktivitasKlienEvent _event, List<DataAktivitas>? _data) {
    data = _data;
  }
}

class AktivitasKlienProgressState extends AktivitasKlienState {}

class LoadMoreProgressState extends AktivitasKlienState {
  LoadMoreProgressState(List<DataAktivitas>? _data) {
    data = _data;
  }
}

class AktivitasErrorState extends AktivitasKlienState {}

class AktivitasKlienBloc
    extends Bloc<AktivitasKlienEvent, AktivitasKlienState> {
  AktivitasKlienState? initialState;
  List<DataAktivitas>? listAktivitas;
  ModelFilter? modelFilter;
  int offset = 0;
  int limit = ServerInfo.limit;

  AktivitasKlienBloc(AktivitasKlienState initialState) : super(initialState);

  @override
  Stream<AktivitasKlienState> mapEventToState(
      AktivitasKlienEvent event) async* {
    if (event is getListAktivitasKlienEvent) {
      offset = 0;
      modelFilter = event.modelFilter;
      yield AktivitasKlienProgressState();
      AktivitasRespon aktivitasRespon = await KoordinatorApi()
          .getDataAktivitasKlien(offset, modelFilter, event.idKlien!);
      if (aktivitasRespon.success!) {
        listAktivitas = aktivitasRespon.data;
        yield getListAktivitasSuccessState(event, listAktivitas);
      } else
        yield AktivitasErrorState();
    } else if (event is loadMoreEvent) {
      if (event.scrollController.offset >=
              event.scrollController.position.maxScrollExtent &&
          !event.scrollController.position.outOfRange) {
        offset = offset + limit;
        yield LoadMoreProgressState(listAktivitas);
        AktivitasRespon aktivitasRespon = await KoordinatorApi()
            .getDataAktivitasKlien(offset, modelFilter, event.idKlien!);
        if (aktivitasRespon.success!) {
          listAktivitas!.addAll(aktivitasRespon.data!);
        }
        yield getListAktivitasSuccessState(event, listAktivitas);
      }
    }
  }
}
