import 'dart:async';
import 'package:absenkuv3/Repository/Model/mAbsensi.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mIzin.dart';
import 'package:absenkuv3/Repository/Service/absensiApi.dart';
import 'package:absenkuv3/Repository/Service/koordinatorApi.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:intl/intl.dart';

abstract class DataAbsensiKlienEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getListDataAbsensiKlienEvent extends DataAbsensiKlienEvent {
  ModelFilter? modelFilter;
  String? idKlien;
  getListDataAbsensiKlienEvent(
    BuildContext _context,
    this.modelFilter,
    String idKlien_,
  ) {
    context = _context;
    idKlien = idKlien_;
  }
}

class getListDataAbsensiSayaEvent extends DataAbsensiKlienEvent {
  ModelFilter? modelFilter;
  getListDataAbsensiSayaEvent(
    BuildContext _context,
    this.modelFilter,
  ) {
    context = _context;
  }
}

class loadMoreEvent extends DataAbsensiKlienEvent {
  late ScrollController scrollController;
  String? idKlien;
  loadMoreEvent(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey,
      ScrollController _scrollController, String? idKlien_) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    scrollController = _scrollController;
    idKlien = idKlien_;
  }
}

class loadMoreSayaEvent extends DataAbsensiKlienEvent {
  late ScrollController scrollController;
  loadMoreSayaEvent(
      BuildContext _context,
      GlobalKey<ScaffoldState> _scaffoldKey,
      ScrollController _scrollController) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    scrollController = _scrollController;
  }
}

abstract class DataAbsensiState {
  List<DataRekapAbsensi>? data;
  DataIzin? dataDetail;
}

class getListDataAbsensiSuccessState extends DataAbsensiState {
  getListDataAbsensiSuccessState(
      DataAbsensiKlienEvent _event, List<DataRekapAbsensi>? _data) {
    data = _data;
  }
}

class getListDataAbsensiSayaSuccessState extends DataAbsensiState {
  getListDataAbsensiSayaSuccessState(
      DataAbsensiKlienEvent _event, List<DataRekapAbsensi>? _data) {
    data = _data;
  }
}

class parseDataDataAbsensiState extends DataAbsensiState {
  parseDataDataAbsensiState(DataIzin _dataDetail) {
    dataDetail = _dataDetail;
  }
}

class DataAbsensiKlienProgressState extends DataAbsensiState {}

class LoadMoreProgressState extends DataAbsensiState {
  LoadMoreProgressState(List<DataRekapAbsensi>? _data) {
    data = _data;
  }
}

class DataAbsensiErrorState extends DataAbsensiState {}

class DataAbsensiKlienBloc
    extends Bloc<DataAbsensiKlienEvent, DataAbsensiState> {
  final dateFormat = new DateFormat('yyyy-MM');
  ModelFilter? modelFilter;
  DataAbsensiState? initialState;
  List<DataRekapAbsensi>? listAbsensi;
  int offset = 0;
  int limit = ServerInfo.limit;

  DataAbsensiKlienBloc(DataAbsensiState initialState) : super(initialState);

  @override
  Stream<DataAbsensiState> mapEventToState(DataAbsensiKlienEvent event) async* {
    if (event is getListDataAbsensiKlienEvent) {
      offset = 0;
      modelFilter = event.modelFilter;
      yield DataAbsensiKlienProgressState();
      RekapAbsensiRespon absensiRespon = await KoordinatorApi()
          .getDataAbsensiKlien(modelFilter, offset, event.idKlien!);
      if (absensiRespon.success!) {
        listAbsensi = absensiRespon.data;
        yield getListDataAbsensiSuccessState(event, listAbsensi);
      } else
        yield DataAbsensiErrorState();
    } else if (event is loadMoreEvent) {
      if (event.scrollController.offset >=
              event.scrollController.position.maxScrollExtent &&
          !event.scrollController.position.outOfRange) {
        offset = offset + limit;
        yield LoadMoreProgressState(listAbsensi);
        RekapAbsensiRespon absensiRespon = await KoordinatorApi()
            .getDataAbsensiKlien(modelFilter, offset, event.idKlien!);
        (modelFilter, offset);
        if (absensiRespon.success!) {
          listAbsensi!.addAll(absensiRespon.data!);
        }
        yield getListDataAbsensiSuccessState(event, listAbsensi);
      }
    }
  }
}
