import 'package:absenkuv3/Repository/Model/mJamKerja.dart';
import 'package:absenkuv3/Repository/Service/jamKerjaApi.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class JamKerjaEvent{
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getJamKerjaEvent extends JamKerjaEvent{
  getJamKerjaEvent(BuildContext _context){
    context = _context;
  }
}


abstract class JamKerjaState{
  DataJamKerja? data;
}

class getJamKerjaSuccessState extends JamKerjaState{
  getJamKerjaSuccessState(JamKerjaEvent _event, DataJamKerja? _data){
    data = _data;
  }
}

class JamKerjaProgressState extends JamKerjaState{}

class LoadMoreProgressState extends JamKerjaState{
  LoadMoreProgressState(DataJamKerja _data){
    data = _data;
  }
}

class JamKerjaErrorState extends JamKerjaState{}

class JamKerjaBloc extends Bloc<JamKerjaEvent, JamKerjaState>{
  JamKerjaState? initialState;
  DataJamKerja? dataJamKerja;

  JamKerjaBloc(JamKerjaState initialState) : super(initialState);

  @override
  Stream<JamKerjaState> mapEventToState(JamKerjaEvent event) async*{
    // TODO: implement mapEventToState
    if(event is getJamKerjaEvent){
      /*yield JamKerjaProgressState();*/
      JamKerjaRespon jamKerjaRespon = await JamKerjaApi().getDataJamKerja();
      if(jamKerjaRespon.success!){
        dataJamKerja = jamKerjaRespon.data;
        yield getJamKerjaSuccessState(event, dataJamKerja);
      }
      else yield JamKerjaErrorState();
    }
  }
}