import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/izinApi.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class SisaCutiEvent{}

class GetSisaCuti extends SisaCutiEvent{}

class GetSisaCutiKaryawan extends SisaCutiEvent{
  String? idKaryawan;
  GetSisaCutiKaryawan(this.idKaryawan);
}

abstract class SisaCutiState{
  BasicSimpleRespon? basicSimpleRespon;
}

class SisaCutiProgress extends SisaCutiState{}

class SisaCutiSuccess extends SisaCutiState{
  SisaCutiSuccess(BasicSimpleRespon _sisaCutiRespon){
    basicSimpleRespon = _sisaCutiRespon;
  }
}

class SisaCutiError extends SisaCutiState{}

class SisaCutiBloc extends Bloc<SisaCutiEvent, SisaCutiState>{
  SisaCutiBloc(SisaCutiState initialState) : super(initialState);


  @override
  Stream<SisaCutiState> mapEventToState(SisaCutiEvent event) async*{
    // TODO: implement mapEventToState
    if(event is GetSisaCuti){
      yield SisaCutiProgress();
      BasicSimpleRespon sisaCutiRespon = await IzinApi().getSisaCuti();
      if(sisaCutiRespon.success!) yield SisaCutiSuccess(sisaCutiRespon);
      else yield SisaCutiError();
    }
    else if(event is GetSisaCutiKaryawan){
      yield SisaCutiProgress();
      BasicSimpleRespon sisaCutiRespon = await IzinApi().getSisaCuti(idKaryawan: event.idKaryawan);
      if(sisaCutiRespon.success!) yield SisaCutiSuccess(sisaCutiRespon);
      else yield SisaCutiError();
    }
  }
}