import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/izinApi.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class JumlahIzinEvent {}

class GetJumlahIzin extends JumlahIzinEvent {
  String? tanggalMulai;
  String? tanggalSelesai;
  String? flagKalender;
  GetJumlahIzin(this.tanggalMulai, this.tanggalSelesai, this.flagKalender);
}
class Hidden extends JumlahIzinEvent {
  Hidden();
}

abstract class JumlahIzinState {
  late BasicSimpleRespon basicSimpleRespon;
}

class JumlahIzinProgress extends JumlahIzinState {}

class JumlahIzinSuccess extends JumlahIzinState {
  JumlahIzinSuccess(BasicSimpleRespon _sisaCutiRespon) {
    basicSimpleRespon = _sisaCutiRespon;
  }
}

class JumlahIzinError extends JumlahIzinState {}
class HidenState extends JumlahIzinState {}

class JumlahIzinBloc extends Bloc<JumlahIzinEvent, JumlahIzinState> {
  JumlahIzinBloc(JumlahIzinState initialState) : super(initialState);

  @override
  Stream<JumlahIzinState> mapEventToState(JumlahIzinEvent event) async* {
    if (event is GetJumlahIzin) {
      yield JumlahIzinProgress();
      debugPrint(event.flagKalender);
      BasicSimpleRespon jumlahIzin = await IzinApi().getJumlahIzin(
          event.tanggalMulai, event.tanggalSelesai, event.flagKalender);
      if (jumlahIzin.success!)
        yield JumlahIzinSuccess(jumlahIzin);
      else
        yield JumlahIzinError();
    }else if (event is Hidden){
      yield HidenState();
    }
  }
}
