import 'package:absenkuv3/Repository/Model/mIzin.dart';
import 'package:absenkuv3/Repository/Service/izinApi.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class DetailIzinEvent{}

class GetDetailIzin extends DetailIzinEvent{
  String? idIzin;
  GetDetailIzin(this.idIzin);
}

abstract class DetailIzinState{}

class DetailIzinProgress extends DetailIzinState{}

class DetailIzinSuccess extends DetailIzinState{
  IzinRespon izinRespon;
  DetailIzinSuccess(this.izinRespon);
}

class DetailIzinError extends DetailIzinState{}

class DetailIzinBloc extends Bloc<DetailIzinEvent, DetailIzinState>{
  DetailIzinBloc(DetailIzinState initialState) : super(initialState);


  @override
  Stream<DetailIzinState> mapEventToState(DetailIzinEvent event) async*{
    // TODO: implement mapEventToState
    if(event is GetDetailIzin){
      yield DetailIzinProgress();
      IzinRespon izinRespon = await IzinApi().getDataIzinDetail(event.idIzin, 'izinDetail');
      if(izinRespon.success!) yield DetailIzinSuccess(izinRespon);
      else yield DetailIzinError();
    }
  }
}