import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mGaji.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/GajiApi.dart';
import 'package:absenkuv3/Repository/Service/userApi.dart';
import 'package:absenkuv3/UI/Template/MonthPicker/Bloc/MonthPickerBloc.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:sn_progress_dialog/sn_progress_dialog.dart';

import '../CustomFunction.dart';

abstract class GajiEvent{
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class GetGajiEvent extends GajiEvent{
  ModelFilter modelFilter;
  GetGajiEvent(BuildContext _context, this.modelFilter){
    context = _context;
  }
}

class InitPasswordEvent extends GajiEvent{}

class CekPasswordEvent extends GajiEvent{
  String password;
  CekPasswordEvent(BuildContext _context, this.password){
    context = _context;
  }
}

abstract class GajiState{
  DataGaji? data;
}

class CekPasswordTrueState extends GajiState{
  CekPasswordTrueState(GajiEvent event){
    Future.delayed(Duration(milliseconds: 600)).then((value) {
      BlocProvider.of<NavigatorBloc>(event.context!).add(NavigatePop(event.context));
      BlocProvider.of<MonthPickerBloc>(event.context!)
          .add(SetDate(DateTime(DateTime.now().year, DateTime.now().month - 1)));
      // BlocProvider.of<NavigatorBloc>(event.context!).add(NavigateToGaji(event.context));
    });

  }
}

class CekPasswordFalseState extends GajiState{
  String? message;
  CekPasswordFalseState(GajiEvent event, this.message);
}

class InitPasswordState extends GajiState{}

class GetGajiSuccessState extends GajiState{
  GetGajiSuccessState(GajiEvent _event, DataGaji? _data){
    data = _data;
  }
}

class GajiProgressState extends GajiState{}

class GajiErrorState extends GajiState{}

class GajiBloc extends Bloc<GajiEvent, GajiState>{
  GajiState? initialState;
  DataGaji? dataGaji;

  GajiBloc(GajiState initialState) : super(initialState);

  @override
  Stream<GajiState> mapEventToState(GajiEvent event) async*{
    // TODO: implement mapEventToState
    if(event is GetGajiEvent){
      yield GajiProgressState();
      GajiRespon gajiRespon = await GajiApi().getDataGaji(event.modelFilter);
      if(gajiRespon.success!){
        dataGaji = gajiRespon.data;
        yield GetGajiSuccessState(event, dataGaji);
      }
      else yield GajiErrorState();
    }
    else if(event is InitPasswordEvent) yield InitPasswordState();
    else if(event is CekPasswordEvent){
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon = await UserApi().cekPassword(event.password);
      ProgressDialogDelayed.hide(pd);
      if(basicRespon.success!) yield CekPasswordTrueState(event);
      else yield CekPasswordFalseState(event, basicRespon.message);
    }
  }
}