import 'package:absenkuv3/Repository/Model/mBadge.dart';
import 'package:absenkuv3/Repository/Model/mFilterHeader.dart';
import 'package:absenkuv3/Repository/Service/filterApi.dart';
import 'package:absenkuv3/Repository/Service/notifApi.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class FilterHeaderEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

abstract class FilterHeaderState {}

class GetFilter extends FilterHeaderEvent {
  GetFilter(
    BuildContext _context,
  ) {
    context = _context;
  }
}

class GetFilterHeader extends FilterHeaderEvent {
  GetFilterHeader(
    BuildContext _context,
  ) {
    context = _context;
  }
}
class GetFilterHeaderLembur extends FilterHeaderEvent {
  GetFilterHeaderLembur(
    BuildContext _context,
  ) {
    context = _context;
  }
}

class GetSuccess extends FilterHeaderState {
  JumlahBadge? dataDashboard;
  GetSuccess(this.dataDashboard) {}
}

class GetSuccessPerColumn extends FilterHeaderState {
  FilterHeader? dataFilter;
  GetSuccessPerColumn(this.dataFilter) {}
}


class GetProgressFilter extends FilterHeaderState {}

class GetFailed extends FilterHeaderState {
  String? message;
  GlobalKey<ScaffoldState>? scaffoldKey;
  GetFailed(this.message, this.scaffoldKey) {}
}

class FilterHeaderBloc extends Bloc<FilterHeaderEvent, FilterHeaderState> {
  FilterHeaderBloc(FilterHeaderState initialState) : super(initialState);

  @override
  Stream<FilterHeaderState> mapEventToState(FilterHeaderEvent event) async* {
    if (event is GetFilter) {
      yield GetProgressFilter();
      JumlahBadge data = await NotifApi().badgeNotif();
      if (data.success!)
        yield GetSuccess(data);
      else
        yield GetFailed(data.message, event.scaffoldKey);
    } else if (event is GetFilterHeader) {
      yield GetProgressFilter();
      FilterHeader data = await FilterApi().filterHeader();
      if (data.success!)
        yield GetSuccessPerColumn(data);
      else
        yield GetFailed(data.message, event.scaffoldKey);
    }else if (event is GetFilterHeaderLembur) {
      yield GetProgressFilter();
      FilterHeader data = await FilterApi().filterHeaderLembur();
      if (data.success!)
        yield GetSuccessPerColumn(data);
      else
        yield GetFailed(data.message, event.scaffoldKey);
    }
  }
}
