import 'package:absenkuv3/Repository/Model/mDropdownLokasi.dart';
import 'package:absenkuv3/Repository/Service/dropdownApi.dart';
import 'package:bloc/bloc.dart';

abstract class DropdownEvent {}

class GetDataDropdown extends DropdownEvent {}

class SelectDataDropdown extends DropdownEvent {
  DataLokasi? selectedValue;
  SelectDataDropdown(this.selectedValue);
}

abstract class DropdownState {}

class DropdownProgressState extends DropdownState {}

class DropdownSuccessState extends DropdownState {
  DropdownLokasi? dropdownRespon;
  DataLokasi? selectedValue;
  DropdownSuccessState(this.dropdownRespon, this.selectedValue);
}

class DropdownErrorState extends DropdownState {}

class DropdownLokasiAktivitasBloc extends Bloc<DropdownEvent, DropdownState> {
  DataLokasi? selectedValue;
  DropdownLokasi? dropdownRespon;

  DropdownLokasiAktivitasBloc(DropdownState initialState) : super(initialState);

  @override
  Stream<DropdownState> mapEventToState(DropdownEvent event) async* {
    if (event is GetDataDropdown) {
      yield DropdownProgressState();
      selectedValue = null;
      dropdownRespon = await DropdownApi().getLokasiAtivitas();
      if (dropdownRespon!.data != null)
        yield DropdownSuccessState(dropdownRespon, null);
      else
        yield DropdownErrorState();
    } else if (event is SelectDataDropdown) {
      selectedValue = event.selectedValue;
      yield DropdownSuccessState(dropdownRespon, selectedValue);
    }
  }
}
