import 'package:absenkuv3/Repository/Model/mDropdown.dart';
import 'package:absenkuv3/Repository/Service/dropdownApi.dart';
import 'package:bloc/bloc.dart';

abstract class DropdownLeadMasterEvent {}

class GetDataDropdownLeadMaster extends DropdownLeadMasterEvent {}

class SelectDataDropdownLeadMaster extends DropdownLeadMasterEvent {
  DataDropdown selectedValue;
  SelectDataDropdownLeadMaster(this.selectedValue);
}

abstract class DropdownLeadMasterState {}

class DropdownLeadMasterProgressState extends DropdownLeadMasterState {}

class DropdownLeadMasterSuccessState extends DropdownLeadMasterState {
  DropdownRespon dropdownRespon;
  DataDropdown? selectedValue;
  DropdownLeadMasterSuccessState(this.dropdownRespon, this.selectedValue);
}

class DropdownLeadMasterErrorState extends DropdownLeadMasterState {}

class DropdownLeadMasterBloc extends Bloc<DropdownLeadMasterEvent, DropdownLeadMasterState> {
  DropdownLeadMasterBloc(DropdownLeadMasterState initialState) : super(initialState);
  DataDropdown? selectedValue;
  DropdownRespon? dropdownRespon;

  @override
  Stream<DropdownLeadMasterState> mapEventToState(DropdownLeadMasterEvent event) async* {
    // TODO: implement mapEventToState
    if (event is GetDataDropdownLeadMaster) {
      yield DropdownLeadMasterProgressState();
      selectedValue = null;
      dropdownRespon = await DropdownApi().getDataLeadMaster();
      if (dropdownRespon!.data != null)
        yield DropdownLeadMasterSuccessState(dropdownRespon!, null);
      else
        yield DropdownLeadMasterErrorState();
    } else if (event is SelectDataDropdownLeadMaster) {
      selectedValue = event.selectedValue;
      yield DropdownLeadMasterSuccessState(dropdownRespon!, selectedValue!);
    }
  }
}
