import 'package:absenkuv3/Repository/Model/Akun/mDataDiri.dart';
import 'package:absenkuv3/Repository/Service/klienApi.dart';
import 'package:bloc/bloc.dart';

abstract class DropdownKlienEvent {}

class GetDataDropdowKlien extends DropdownKlienEvent {}

class SelectDataDropdownKlien extends DropdownKlienEvent {
  JenisData selectedValue;
  SelectDataDropdownKlien(this.selectedValue);
}

abstract class DropdownKlienState {}

class DropdownKlienProgressState extends DropdownKlienState {}

class DropdownKlienSuccessState extends DropdownKlienState {
  JenisDataRespon dropdownRespon;
  JenisData? selectedValue;
  DropdownKlienSuccessState(this.dropdownRespon, this.selectedValue);
}

class DropdownKlienErrorState extends DropdownKlienState {}

class DropdownKlienBloc extends Bloc<DropdownKlienEvent, DropdownKlienState> {
  DropdownKlienBloc(DropdownKlienState initialState) : super(initialState);
  JenisData? selectedValue;
  JenisDataRespon? dropdownRespon;

  @override
  Stream<DropdownKlienState> mapEventToState(DropdownKlienEvent event) async* {
    if (event is GetDataDropdowKlien) {
      yield DropdownKlienProgressState();
      selectedValue = null;
      dropdownRespon = await KlienApi().getDataDropdownKlien();
      if (dropdownRespon!.data != null)
        yield DropdownKlienSuccessState(dropdownRespon!, null);
      else
        yield DropdownKlienErrorState();
    } else if (event is SelectDataDropdownKlien) {
      selectedValue = event.selectedValue;
      yield DropdownKlienSuccessState(dropdownRespon!, selectedValue!);
    }
  }
}
