import 'package:absenkuv3/Repository/Model/SalesActivity/mJenisAktivitasSales.dart';
import 'package:absenkuv3/Repository/Service/dropdownApi.dart';
import 'package:bloc/bloc.dart';

abstract class DropdownJenisAktivitasEvent {}

class GetDataDropdownJenisAktivitas extends DropdownJenisAktivitasEvent {}

class SelectDataDropdownJenisAktivitas extends DropdownJenisAktivitasEvent {
  Data selectedValue;
  SelectDataDropdownJenisAktivitas(this.selectedValue);
}

abstract class DropdownJenisAktivitasState {}

class DropdownJenisAktivitasProgressState extends DropdownJenisAktivitasState {}

class DropdownJenisAktivitasSuccessState extends DropdownJenisAktivitasState {
  JenisAktivitasSalesRespon dropdownRespon;
  Data? selectedValue;
  DropdownJenisAktivitasSuccessState(this.dropdownRespon, this.selectedValue);
}

class DropdownJenisAktivitasErrorState extends DropdownJenisAktivitasState {}

class DropdownJenisAktivitasBloc extends Bloc<DropdownJenisAktivitasEvent, DropdownJenisAktivitasState> {
  DropdownJenisAktivitasBloc(DropdownJenisAktivitasState initialState) : super(initialState);
  Data? selectedValue;
  JenisAktivitasSalesRespon? dropdownRespon;

  @override
  Stream<DropdownJenisAktivitasState> mapEventToState(DropdownJenisAktivitasEvent event) async* {
    // TODO: implement mapEventToState
    if (event is GetDataDropdownJenisAktivitas) {
      yield DropdownJenisAktivitasProgressState();
      selectedValue = null;
      dropdownRespon = await DropdownApi().getDataJenisAktivitas();
      if (dropdownRespon!.data != null)
        yield DropdownJenisAktivitasSuccessState(dropdownRespon!, null);
      else
        yield DropdownJenisAktivitasErrorState();
    } else if (event is SelectDataDropdownJenisAktivitas) {
      selectedValue = event.selectedValue;
      yield DropdownJenisAktivitasSuccessState(dropdownRespon!, selectedValue!);
    }
  }
}
