import 'package:absenkuv3/Repository/Model/Akun/mDataDiri.dart';
import 'package:absenkuv3/Repository/Service/Akun/dropDownAkunApi.dart';
import 'package:bloc/bloc.dart';

abstract class DropdownPekerjaanEvent {}

class GetDataDropdownPekerjaan extends DropdownPekerjaanEvent {}

class SelectDataDropdownPekerjaan extends DropdownPekerjaanEvent {
  JenisData selectedValue;
  SelectDataDropdownPekerjaan(this.selectedValue);
}

abstract class DropdownPekerjaanState {}

class DropdownPekerjaanProgressState extends DropdownPekerjaanState {}

class DropdownPekerjaanSuccessState extends DropdownPekerjaanState {
  JenisDataRespon dropdownRespon;
  JenisData? selectedValue;
  DropdownPekerjaanSuccessState(this.dropdownRespon, this.selectedValue);
}

class DropdownPekerjaanErrorState extends DropdownPekerjaanState {}

class DropdownPekerjaanBloc extends Bloc<DropdownPekerjaanEvent, DropdownPekerjaanState> {
  DropdownPekerjaanBloc(DropdownPekerjaanState initialState) : super(initialState);
  JenisData? selectedValue;
  JenisDataRespon? dropdownRespon;

  @override
  Stream<DropdownPekerjaanState> mapEventToState(DropdownPekerjaanEvent event) async* {
    // TODO: implement mapEventToState
    if (event is GetDataDropdownPekerjaan) {
      yield DropdownPekerjaanProgressState();
      selectedValue = null;
      dropdownRespon = await DropdownAkunApi().getJenisPekerjaan();
      if (dropdownRespon!.data != null)
        yield DropdownPekerjaanSuccessState(dropdownRespon!, null);
      else
        yield DropdownPekerjaanErrorState();
    } else if (event is SelectDataDropdownPekerjaan) {
      selectedValue = event.selectedValue;
      yield DropdownPekerjaanSuccessState(dropdownRespon!, selectedValue!);
    }
  }
}
