import 'package:absenkuv3/Repository/Model/Akun/mDataDiri.dart';
import 'package:absenkuv3/Repository/Service/Akun/dropDownAkunApi.dart';
import 'package:bloc/bloc.dart';

abstract class DropdownJenisKelaminEvent {}

class GetDataDropdownJenisKelamin extends DropdownJenisKelaminEvent {}

class SelectDataDropdownJenisKelamin extends DropdownJenisKelaminEvent {
  JenisData selectedValue;
  SelectDataDropdownJenisKelamin(this.selectedValue);
}

abstract class DropdownJenisKelaminState {}

class DropdownJenisKelaminProgressState extends DropdownJenisKelaminState {}

class SetJenisKelamin extends DropdownJenisKelaminEvent{
  JenisData data;
  SetJenisKelamin(this.data);
}

class DropdownJenisKelaminSuccessState extends DropdownJenisKelaminState {
  JenisDataRespon dropdownRespon;
  JenisData? selectedValue;
  DropdownJenisKelaminSuccessState(this.dropdownRespon, this.selectedValue);
}

class DropdownJenisKelaminErrorState extends DropdownJenisKelaminState {}

class DropdownJenisKelaminBloc extends Bloc<DropdownJenisKelaminEvent, DropdownJenisKelaminState> {
  DropdownJenisKelaminBloc(DropdownJenisKelaminState initialState) : super(initialState);
  JenisData? selectedValue;
  JenisDataRespon? dropdownRespon;

  @override
  Stream<DropdownJenisKelaminState> mapEventToState(DropdownJenisKelaminEvent event) async* {
    // TODO: implement mapEventToState
    if (event is GetDataDropdownJenisKelamin) {
      yield DropdownJenisKelaminProgressState();
      selectedValue = null;
      dropdownRespon = await DropdownAkunApi().getJenisKelamin();
      if (dropdownRespon!.data != null)
        yield DropdownJenisKelaminSuccessState(dropdownRespon!, null);
      else
        yield DropdownJenisKelaminErrorState();
    } else if (event is SelectDataDropdownJenisKelamin) {
      selectedValue = event.selectedValue;
      yield DropdownJenisKelaminSuccessState(dropdownRespon!, selectedValue);
    } else if(event is SetJenisKelamin){
      selectedValue = event.data;
      yield DropdownJenisKelaminSuccessState(dropdownRespon!, selectedValue);
    }
  }
}
