import 'package:absenkuv3/Repository/Model/Akun/mDataDiri.dart';
import 'package:absenkuv3/Repository/Service/Akun/dropDownAkunApi.dart';
import 'package:bloc/bloc.dart';

abstract class DropdownGolonganDarahEvent {}

class GetDataDropdownGolonganDarah extends DropdownGolonganDarahEvent {}

class SelectDataDropdownGolonganDarah extends DropdownGolonganDarahEvent {
  JenisData selectedValue;
  SelectDataDropdownGolonganDarah(this.selectedValue);
}

abstract class DropdownGolonganDarahState {}

class DropdownGolonganDarahProgressState extends DropdownGolonganDarahState {}

class DropdownGolonganDarahSuccessState extends DropdownGolonganDarahState {
  JenisDataRespon dropdownRespon;
  JenisData? selectedValue;
  DropdownGolonganDarahSuccessState(this.dropdownRespon, this.selectedValue);
}

class DropdownGolonganDarahErrorState extends DropdownGolonganDarahState {}

class DropdownGolonganDarahBloc extends Bloc<DropdownGolonganDarahEvent, DropdownGolonganDarahState> {
  DropdownGolonganDarahBloc(DropdownGolonganDarahState initialState) : super(initialState);
  JenisData? selectedValue;
  JenisDataRespon? dropdownRespon;

  @override
  Stream<DropdownGolonganDarahState> mapEventToState(DropdownGolonganDarahEvent event) async* {
    // TODO: implement mapEventToState
    if (event is GetDataDropdownGolonganDarah) {
      yield DropdownGolonganDarahProgressState();
      selectedValue = null;
      dropdownRespon = await DropdownAkunApi().getJenisGolonganDarah();
      if (dropdownRespon!.data != null)
        yield DropdownGolonganDarahSuccessState(dropdownRespon!, null);
      else
        yield DropdownGolonganDarahErrorState();
    } else if (event is SelectDataDropdownGolonganDarah) {
      selectedValue = event.selectedValue;
      yield DropdownGolonganDarahSuccessState(dropdownRespon!, selectedValue!);
    }
  }
}
