import 'package:absenkuv3/Repository/Model/Cuti/mDataCuti.dart';
import 'package:absenkuv3/Repository/Service/cutiApi.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class GetDataCutiEvent {}

class GetDataCuti extends GetDataCutiEvent {
  GetDataCuti();
}

abstract class DataCutiState {}

class DataCutiProggres extends DataCutiState {}

class DataCutiSuccessState extends DataCutiState {
  Respondatacuti respon;
  DataCutiSuccessState(this.respon);
}

class DataCutiError extends DataCutiState {}

class DataCutiBloc
    extends Bloc<GetDataCutiEvent, DataCutiState> {
  DataCutiBloc(DataCutiState initialState) : super(initialState);

  @override
  Stream<DataCutiState> mapEventToState(
      GetDataCutiEvent event) async* {
    if (event is GetDataCuti) {
      yield DataCutiProggres();
      Respondatacuti respon =
          await CutiApi().getDataCuti();
      if (respon.success!)
        yield DataCutiSuccessState(respon);
      else
        yield DataCutiError();
    }
  }
}
