import 'package:absenkuv3/Repository/Model/mBerita.dart';
import 'package:absenkuv3/Repository/Service/beritaApi.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class DetailBeritaEvent{}

class GetDetailBerita extends DetailBeritaEvent{
  String? id;
  GetDetailBerita(this.id);
}

abstract class DetailBeritaState{}

class DetailBeritaProgress extends DetailBeritaState{}

class DetailBeritaSuccess extends DetailBeritaState{
  BeritaRespon beritaRespon;
  DetailBeritaSuccess(this.beritaRespon);
}

class DetailBeritaError extends DetailBeritaState{}

class DetailBeritaBloc extends Bloc<DetailBeritaEvent, DetailBeritaState>{
  DetailBeritaBloc(DetailBeritaState initialState) : super(initialState);



  @override
  Stream<DetailBeritaState> mapEventToState(DetailBeritaEvent event) async*{
    // TODO: implement mapEventToState
    if(event is GetDetailBerita){
      yield DetailBeritaProgress();
      BeritaRespon beritaRespon = await BeritaApi().getDetailBerita(event.id);
      if(beritaRespon.success!) yield DetailBeritaSuccess(beritaRespon);
      else yield DetailBeritaError();
    }
  }
}