import 'package:absenkuv3/Bloc/CustomBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/Akun/View/mDataDataDiri.dart';
import 'package:absenkuv3/Repository/Model/Akun/mNotifikasiAkun.dart';
// import 'package:absenkuv3/Repository/Model/Akun/mDataDiri.dart';
import 'package:absenkuv3/Repository/Service/Akun/dataDiriApi.dart';
import 'package:flutter/material.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';
import 'package:sn_progress_dialog/sn_progress_dialog.dart';

abstract class DataDiriEvent{
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getDataDiriEvent extends DataDiriEvent{
  getDataDiriEvent(BuildContext _context){
    context = _context;
  }
}

class getDataPengajuanDataDiriEvent extends DataDiriEvent{
  getDataPengajuanDataDiriEvent(BuildContext _context){
    context = _context;
  }
}

class getDetailDataDiriByIdEvent extends DataDiriEvent{
  DataNotifikasiAkun? dataNotifikasiAkun;
  getDetailDataDiriByIdEvent(BuildContext _context, DataNotifikasiAkun _data){
    context = _context;
    dataNotifikasiAkun = _data;
  }
}

abstract class DataDiriState{
  DataDatadiri? data;
}

class getDataDiriSuccessState extends DataDiriState{
  getDataDiriSuccessState(DataDiriEvent _event, DataDatadiri _data){
    data = _data;
  }
}

class DataDiriProgressState extends DataDiriState{}

class DataDiriErrorState extends DataDiriState{}

class DataDiriBloc extends Bloc<DataDiriEvent, DataDiriState>{
  final dateFormat = new DateFormat('yyyy-MM');
  DataDatadiri? dataDatadiri;
  ModelFilter? modelFilter;
  int offset = 0;
  int limit = ServerInfo.limit;
  DataDiriBloc(DataDiriState initialState) : super(initialState);

  @override
  Stream<DataDiriState> mapEventToState(DataDiriEvent event) async*{
    if(event is getDataDiriEvent){
      offset = 0;
      yield DataDiriProgressState();
      DataDataDiriRespon dataDiriRespon = await DataDiriApi().getDataDiri();
      if(dataDiriRespon.success!){
        dataDatadiri = dataDiriRespon.dataDatadiri;
        yield getDataDiriSuccessState(event, dataDatadiri!);
      }
      else yield DataDiriErrorState();
    }
    else if(event is getDataPengajuanDataDiriEvent){
      offset = 0;
      yield DataDiriProgressState();
      DataDataDiriRespon dataDiriRespon = await DataDiriApi().getDataPengajuanDataDiri();
      if(dataDiriRespon.success!){
        dataDatadiri = dataDiriRespon.dataDatadiri;
        yield getDataDiriSuccessState(event, dataDatadiri!);
      }
      else yield DataDiriErrorState();
    }else if(event is getDetailDataDiriByIdEvent){
      offset = 0;
      yield DataDiriProgressState();
      DataDataDiriRespon dataDiriRespon = await DataDiriApi().getDetailDataDiriById(event.dataNotifikasiAkun!);
      if(dataDiriRespon.success!){
        yield getDataDiriSuccessState(event, dataDiriRespon.dataDatadiri!);
      }
      else yield DataDiriErrorState();
    }
  }
}