import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';

class TemplateMenu extends StatelessWidget {
  final icon;
  final String title;
  final String subtitle;
  final onClick;
  final int jumlahBadge;
  TemplateMenu(
      {this.icon,
      this.title = '',
      this.subtitle = '',
      this.onClick,
      this.jumlahBadge = 0});

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: EdgeInsets.symmetric(vertical: 5, horizontal: 20),
      decoration: CustomStyle.boxDecoration,
      child: ListTile(
        leading: Container(width: 50, height: 50, child: Image.asset(icon)),
        title: Text(
          title,
          style: TextStyle(
              fontSize: CustomStyle.fontSizeSmall, fontWeight: FontWeight.bold),
        ),
        subtitle: Text(
          subtitle,
          style: TextStyle(fontSize: 12, color: Colors.grey),
        ),
        onTap: onClick,
        trailing: Row(
          mainAxisSize: MainAxisSize.min,
          children: [
            jumlahBadge > 0
                ? Container(
                    child: Center(
                      child: Text(
                        jumlahBadge.toString(),
                        style: TextStyle(color: Colors.white),
                      ),
                    ),
                    decoration: new BoxDecoration(
                      color: Colors.red,
                      shape: BoxShape.circle,
                    ),
                    height: MediaQuery.of(context).size.width * 0.05,
                    width: MediaQuery.of(context).size.width * 0.05,
                  )
                : Container(),
            Icon(
              Icons.arrow_forward_ios,
              size: 20,
              color: Colors.blueAccent,
            ),
          ],
        ),
      ),
    );
  }
}
