import 'package:flutter/material.dart';
import 'package:flutter/services.dart';


typedef void TemplateFormKanbanCallback(val);

class TemplateFormKanban extends StatefulWidget {
  final Key? fieldKey;
  final String? hintText;
  final String? labelText;
  final String? helperText;
  final String? titleText;
  final String? titleText2;
  var color;
  var colorTitle2;
  var initialValue;
  final double? fontSize;
  final double? formHeight;
  final FormFieldSetter<String>? onSaved;
  final FormFieldSetter<String>? onChange;
  final FormFieldValidator<String>? validator;
  final TextEditingController? controller;
  final TextCapitalization textCapitalization;
  var formatter;
  final bool enabled;
  final bool adaValidasi;
  final bool keyboardNumber;
  final bool numberOnly;
  final double bottomMargin;
  final double? radius;
  final int maxLine;
  final int minLine;
  var contentPadding;
  var prefixIcon;
  var suffixIcon;
  var buttonEnd;
  TemplateFormKanbanCallback? dataCallback;
  TemplateFormKanban(
      {this.fieldKey,
      this.hintText,
      this.helperText,
      this.labelText,
      this.onSaved,
      this.onChange,
      this.validator,
      this.controller,
      this.enabled = true,
      this.adaValidasi = false,
      this.keyboardNumber = false,
      this.numberOnly = false,
      this.titleText,
      this.titleText2 = '',
      this.textCapitalization = TextCapitalization.words,
      this.bottomMargin = 12.0,
      this.maxLine = 1,
      this.initialValue,
      this.prefixIcon,
      this.suffixIcon,
      this.color = Colors.white,
      this.colorTitle2 = Colors.white,
      this.fontSize = 14,
      this.radius = 16,
      this.formHeight = 48,
      this.minLine = 1,
      this.formatter,
      this.buttonEnd,
      this.contentPadding = const EdgeInsets.fromLTRB(20.0, 0, 20.0, 0),
      this.dataCallback});
  @override
  _TemplateFormKanbanState createState() => _TemplateFormKanbanState();
}

class _TemplateFormKanbanState extends State<TemplateFormKanban> {
  String? _validate(String? value) {
    if (value!.isEmpty) return 'Please fill this form.';
    return null;
  }
  var focusNode = FocusNode();

  @override
  void initState() {
    focusNode.addListener(() {
      widget.dataCallback!(focusNode.hasFocus);
    });
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: EdgeInsets.only(bottom: widget.bottomMargin),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: <Widget>[
          widget.controller!.text.trim().isNotEmpty||focusNode.hasFocus
            ? widget.titleText != ''&&widget.titleText!=null
              ? Padding(
                  padding: const EdgeInsets.only(bottom: 8),
                  child: widget.titleText2!=null?Row(
                    children: [
                      Text(
                        widget.titleText!,
                        style: TextStyle(
                            // color: widget.color,
                            color: Colors.grey,
                            fontWeight: FontWeight.w500,
                            fontSize: widget.fontSize),
                      ),
                      SizedBox(width: 4,),
                      Text(
                        widget.titleText2!,
                        style: TextStyle(
                            color: widget.colorTitle2,
                            fontWeight: FontWeight.bold,
                            fontSize: widget.fontSize),
                      )
                    ],
                  ):Text(
                    widget.titleText!,
                    style: TextStyle(
                        color: widget.color,
                        fontWeight: FontWeight.bold,
                        fontSize: widget.fontSize),
                  ),
                )
              : Container()
            : Container(
                margin: EdgeInsets.only(bottom: 8),
              ),
          Container(
            padding: EdgeInsets.only(right: 6),
            height: widget.formHeight,
            child: Row(
              children: [
                Expanded(
                  child: TextFormField(
                    minLines: widget.minLine,
                    initialValue: widget.initialValue,
                    cursorColor: widget.color,
                    maxLines: widget.maxLine,
                    controller: widget.controller,
                    focusNode: focusNode,
                    keyboardType: widget.keyboardNumber
                        ? TextInputType.number
                        : TextInputType.text,
                    inputFormatters: widget.numberOnly
                        ? <TextInputFormatter>[
                            FilteringTextInputFormatter.digitsOnly,
                          ]
                        : widget.formatter != null
                            ? [
                                widget.formatter,
                              ]
                            : null,
                    key: widget.fieldKey,
                    enabled: widget.enabled,
                    onTap: (){
                      widget.dataCallback!(true);
                    },
                    style: TextStyle(
                        fontSize: widget.fontSize, color: widget.color),
                    decoration: InputDecoration(
                        disabledBorder: UnderlineInputBorder(borderSide: BorderSide(
                          color: Colors.grey.shade200
                        )),
                        enabledBorder: UnderlineInputBorder(borderSide: BorderSide(
                            color: Colors.grey.shade200
                        )),
                        hintStyle: TextStyle(
                            color: widget.enabled
                                ? widget.color
                                : Colors.grey[600]),
                        suffixIcon: widget.suffixIcon,
                        contentPadding: widget.contentPadding,
                        hintText: widget.controller!.text.trim().isNotEmpty||focusNode.hasFocus?"":widget.hintText,
                        ),
                    validator: widget.adaValidasi == true ? _validate : null,
                    onSaved: widget.onSaved,
                    onChanged: widget.onChange,
                  ),
                ),
                widget.buttonEnd ?? Container()
              ],
            ),
          ),
        ],
      ),
    );
  }
}
