import 'package:flutter/material.dart';
import 'package:fluttertoast/fluttertoast.dart';
class CustomToast extends StatefulWidget {
  String? message;
  CustomToast({this.message});

  @override
  State<CustomToast> createState() => _CustomToastState();
}

class _CustomToastState extends State<CustomToast> {
  @override
  Widget build(BuildContext context) {
    return Container(
      padding: const EdgeInsets.symmetric(horizontal: 24.0, vertical: 12.0),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(25.0),
        color: Color(0XFFFF6969),
        // color: Colors.amber.shade300
      ),
      child: Row(
        children: [
          Icon(Icons.close, color: Colors.white),
          SizedBox(
            width: 12.0,
          ),
          Expanded(
            child: Text(
              widget.message.toString(),
              style: TextStyle(color: Colors.white),textAlign: TextAlign.center,
            ),
          ),
        ],
      ),
    );
  }
}

class showToastMessageError {
  showToastMessageError({
    required BuildContext? context,
    required String? message
    }){
  late FToast fToast;
  fToast = FToast();
  fToast.init(context!);
  fToast.showToast(
    child: CustomToast(message:message),
    gravity: ToastGravity.TOP,
  );
  }
}
