import 'package:absenkuv3/Repository/Model/mDropdown.dart';
import 'package:bloc/bloc.dart';

abstract class DropdownEvent {}

class SelectDataCabang extends DropdownEvent {
  DataDropdown? selectedValue;
  SelectDataCabang(this.selectedValue);
}

abstract class CabangSelectedState {}

class CabangSelectedInitial extends CabangSelectedState {}

class CabangSelectedSuccessState extends CabangSelectedState {
  DataDropdown? selectedValue;
  CabangSelectedSuccessState(this.selectedValue);
}

class DropdownErrorState extends CabangSelectedState {}

class CabangSelectedBloc extends Bloc<DropdownEvent, CabangSelectedState> {
  DataDropdown? selectedValue;
  CabangSelectedBloc(CabangSelectedState initialState) : super(initialState);
  @override
  Stream<CabangSelectedState> mapEventToState(DropdownEvent event) async* {
    if (event is SelectDataCabang) {
      selectedValue = event.selectedValue;
      yield CabangSelectedSuccessState(selectedValue);
    }
  }
}
