import 'dart:math';

import 'package:flutter/material.dart';

class DashedRect extends CustomPainter {
  final Color color;
  final double strokeWidth;
  final double gap;
  final double dashWidth;

  DashedRect({this.color = Colors.grey, this.strokeWidth = 1.0, this.gap = 4.0, this.dashWidth = 6.0});

  @override
  void paint(Canvas canvas, Size size) {
    var paint = Paint()
      ..color = color
      ..strokeWidth = strokeWidth
      ..style = PaintingStyle.stroke;

    var path = Path();

    // Horizontal top
    _drawDashedLine(canvas, Offset(0, 0), Offset(size.width, 0), paint);
    // Horizontal bottom
    _drawDashedLine(canvas, Offset(0, size.height), Offset(size.width, size.height), paint);
    // Vertical left
    _drawDashedLine(canvas, Offset(0, 0), Offset(0, size.height), paint);
    // Vertical right
    _drawDashedLine(canvas, Offset(size.width, 0), Offset(size.width, size.height), paint);
  }

  void _drawDashedLine(Canvas canvas, Offset start, Offset end, Paint paint) {
    var dx = end.dx - start.dx;
    var dy = end.dy - start.dy;
    var distance = sqrt(dx * dx + dy * dy);
    var dashCount = (distance / (dashWidth + gap)).floor();
    var dashVector = Offset(dx / distance * dashWidth, dy / distance * dashWidth);
    var gapVector = Offset(dx / distance * gap, dy / distance * gap);

    var current = start;
    for (int i = 0; i < dashCount; ++i) {
      canvas.drawLine(current, current + dashVector, paint);
      current += dashVector + gapVector;
    }
  }

  @override
  bool shouldRepaint(DashedRect oldDelegate) => false;
}
