import 'package:bloc/bloc.dart';

abstract class MonthPickerRekapEvent{}

class GetCurrentDate extends MonthPickerRekapEvent{}

class InitStateDate extends MonthPickerRekapEvent{}

class SetDate extends MonthPickerRekapEvent{
  DateTime? date;
  SetDate(this.date);
}

abstract class MonthPickerRekapState{
  DateTime? dateTime;
}

class MonthPickerProgressRekapState extends MonthPickerRekapState{}

class ChangeMonthSuccessState extends MonthPickerRekapState{
  ChangeMonthSuccessState(_dateTime){
    dateTime = _dateTime;
  }
}

class StateDateSetState extends MonthPickerRekapState {
  DateTime? setDateValue;
  StateDateSetState(this.setDateValue);
}


class MonthPickerRekapBloc extends Bloc<MonthPickerRekapEvent, MonthPickerRekapState>{
  DateTime? date;

  MonthPickerRekapBloc(MonthPickerRekapState initialState) : super(initialState);

  @override
  Stream<MonthPickerRekapState> mapEventToState(MonthPickerRekapEvent event) async*{
    if(event is GetCurrentDate) date = DateTime.now();
    else if(event is InitStateDate) date = null;
    else if(event is SetDate) {
      date = event.date;
      yield StateDateSetState(date);
    }
    yield ChangeMonthSuccessState(date);
  }
}