import 'package:bloc/bloc.dart';

abstract class MonthPickerEvent{}

class GetCurrentDate extends MonthPickerEvent{}

class InitStateDate extends MonthPickerEvent{}

class SetDate extends MonthPickerEvent{
  DateTime? date;
  SetDate(this.date);
}

abstract class MonthPickerState{
  DateTime? dateTime;
}

class MonthPickerProgressState extends MonthPickerState{}

class ChangeMonthSuccessState extends MonthPickerState{
  ChangeMonthSuccessState(_dateTime){
    dateTime = _dateTime;
  }
}

class StateDateSetState extends MonthPickerState {
  DateTime? setDateValue;
  StateDateSetState(this.setDateValue);
}


class MonthPickerBloc extends Bloc<MonthPickerEvent, MonthPickerState>{
  DateTime? date;

  MonthPickerBloc(MonthPickerState initialState) : super(initialState);

  @override
  Stream<MonthPickerState> mapEventToState(MonthPickerEvent event) async*{
    // TODO: implement mapEventToState
    if(event is GetCurrentDate) date = DateTime.now();
    else if(event is InitStateDate) date = null;
    else if(event is SetDate) {
      date = event.date;
      yield StateDateSetState(date);
    }
    yield ChangeMonthSuccessState(date);
  }
}