import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/Bloc/DateRangePickerBloc.dart';
import 'package:absenkuv3/UI/Template/MonthPicker/Bloc/MonthPickerBloc.dart' as monthPicker;
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';

// ignore: must_be_immutable
class TemplateDateRangePicker extends StatefulWidget {
  List<DateTime>? initialData;
  double height;
  DateTime? firstDate;
  DateTime? lastDate;
  TemplateDateRangePicker({this.initialData, this.height = 46, this.firstDate, this.lastDate }){
    firstDate = firstDate??DateTime(DateTime.now().year-1);
    lastDate = lastDate??DateTime(DateTime.now().year, DateTime.now().month, DateTime.now().day);
  }
  @override
  _TemplateDateRangePickerState createState() => _TemplateDateRangePickerState();
}

class _TemplateDateRangePickerState extends State<TemplateDateRangePicker> {
  DateTime selectedDate = DateTime.now();
  final dateFormat = new DateFormat('dd-MM-yyyy');
  DateTime? maxDate;

  @override
  void initState() {
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder(
        future: PengaturanBahasa().getDataBahasa(),
        builder: (context, snapshot){
          return BlocBuilder<DateRangePickerBloc, DateRangePickerState>(
            builder: (BuildContext context, DateRangePickerState dateRangePickerState){
              print("kakaka disini");
              print(dateRangePickerState);
              String label = '-';
              DateTime startDate = DateTime(DateTime.now().year, DateTime.now().month, DateTime.now().day);
              DateTime endDate = DateTime(DateTime.now().year, DateTime.now().month, DateTime.now().day);
              if(dateRangePickerState is DateAvailable){
                label = '${dateFormat.format(dateRangePickerState.date[0])} sd ${dateFormat.format(dateRangePickerState.date[1])}';
                startDate = dateRangePickerState.date[0];
                endDate = dateRangePickerState.date[1];
              }
              return GestureDetector(
                onTap: () async{
                  BlocProvider.of<monthPicker.MonthPickerBloc>(context).add(monthPicker.SetDate(null)); //RESET MONTH
                  final DateTimeRange? picked = await showDateRangePicker(
                      context: context,
                      firstDate: widget.firstDate!,
                      lastDate: widget.lastDate!,
                      locale: Locale(snapshot.data??'en'),
                      saveText: snapshot.data == null ? 'TERAPKAN' : snapshot.data == 'id' ? 'TERAPKAN' : 'APPLY',
                      initialDateRange: DateTimeRange(
                          start: startDate,
                          end: endDate
                      ));
                  if (picked != null) BlocProvider.of<DateRangePickerBloc>(context).add(SetDate([picked.start, picked.end]));
                },
                child: Column(
                  children: [
                    Container(
                      padding: EdgeInsets.fromLTRB(16, 7, 16, 7),
                      decoration: BoxDecoration(
                          boxShadow: [
                            BoxShadow(
                              color: Colors.grey.withOpacity(0.3),
                              spreadRadius: 2,
                              blurRadius: 5,
                              offset: Offset(0, 1), // changes position of shadow
                            ),
                          ],
                          gradient: LinearGradient(
                              begin: Alignment.centerLeft,
                              end: Alignment.centerRight,
                              stops: [ 0.0,0.5,1.0],
                              colors: [
                                CustomStyle.color1,
                                Colors.lightBlue,
                                CustomStyle.color1,
                              ]),
                          borderRadius: new BorderRadius.all(
                            Radius.circular(20),
                          )),
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.center,
                        children: [
                          Text(snapshot.data == null ? "Range Tanggal" : snapshot.data == 'id' ? "Range Tanggal" : "Date Range", style: TextStyle(color: Colors.white, fontWeight: FontWeight.w600, fontSize: CustomStyle.fontSizeSmall),),
                          SizedBox(height: 1,),
                          Row(
                            mainAxisAlignment: MainAxisAlignment.center,
                            children: [
                              SizedBox(width: 8,),
                              Text(label, style: TextStyle(fontSize: CustomStyle.fontSizeSmall-1, color: Colors.white),),
                              SizedBox(width: 4,),
                              Icon(Icons.keyboard_arrow_down, color: Colors.white,  size: 18)
                            ],
                          ),
                        ],
                      ),
                    ),
                  ],
                ),
              );
            },
          );
        }
    );
  }
}
