import 'package:bloc/bloc.dart';

abstract class DateRangePickerEvent{}

class InitialDate extends DateRangePickerEvent{}

class SetDate extends DateRangePickerEvent{
  List<DateTime> date;
  SetDate(this.date);
}

abstract class DateRangePickerState{}

class DateAvailable extends DateRangePickerState{
  List<DateTime> date;
  DateAvailable(this.date);
}

class DateUnavailable extends DateRangePickerState{}

class DateRangePickerBloc extends Bloc<DateRangePickerEvent, DateRangePickerState>{
  List<DateTime> date = <DateTime>[];

  DateRangePickerBloc(DateRangePickerState initialState) : super(initialState);

  @override
  Stream<DateRangePickerState> mapEventToState(DateRangePickerEvent event) async*{
    // TODO: implement mapEventToState
    if(event is InitialDate) {
      date.clear();
      yield DateUnavailable();
    }
    else if(event is SetDate) {
      date = event.date;
      yield DateAvailable(date);
    }

  }
}