import 'package:absenkuv3/UI/Template/templateTextFormAkun.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart' as intl;
import '../Bloc/TemplateTimePickerBloc.dart';

// ignore: must_be_immutable
class TemplateTimePickerAktivitas extends StatefulWidget {
  TimeOfDay? initialData;
  double height;
  String title;
  bool validasi;
  double marginHorizontal;
  TextEditingController? textEditingController;
  bool enableClicked;
  TemplateTimePickerAktivitas(this.title,{this.initialData, this.height = 46, this.validasi = false, this.marginHorizontal = 0, this.textEditingController, this.enableClicked = true});

  @override
  _TemplateTimePickerAktivitasState createState() => _TemplateTimePickerAktivitasState();
}

class _TemplateTimePickerAktivitasState extends State<TemplateTimePickerAktivitas> {
  DateTime selectedDate = DateTime.now();
  // final dateFormat = new DateFormat('dd-MM-yyyy');
  final dateFormat = intl.DateFormat('H:i', 'id_ID');

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return BlocBuilder<TemplateTimePickerBloc, TimeOfDay>(
      builder: (BuildContext context, TimeOfDay date){
        return GestureDetector(
          onTap: widget.enableClicked ? () async{
            final TimeOfDay? picked = await showTimePicker(
              context: context,
              initialTime: TimeOfDay.now(),
              initialEntryMode: TimePickerEntryMode.inputOnly,
              orientation: Orientation.portrait,
              builder: (BuildContext context, Widget? child) {
                return Theme(
                  data: Theme.of(context).copyWith(
                    materialTapTargetSize: MaterialTapTargetSize.padded,
                  ),
                  child: Directionality(
                    textDirection: TextDirection.rtl,
                    child: MediaQuery(
                      data: MediaQuery.of(context).copyWith(
                        alwaysUse24HourFormat: true,
                      ),
                      child: child!,
                    ),
                  ),
                );
              },
            );
            if (picked != null)
              BlocProvider.of<TemplateTimePickerBloc>(context).add(SetTime(picked));
          }:null,
          child: Container(
            child: TemplateTextFormAkun(
                bottomMargin: 0,
                enabled: false,
                suffixIcon: Container(
                    margin: EdgeInsets.only(right: 15),
                    child: Icon(Icons.access_time_rounded, size: 20)),
                fontSize: 13,
                adaValidasi: widget.validasi,
                controller: widget.textEditingController,
                titleText:widget.title,
                marginHorizontal: widget.marginHorizontal,
                hintText: "${date.hour}:${date.minute}" == "00:00"
                            ? widget.initialData == null
                              ? "00:00"
                              : "${widget.initialData!.hour}:${widget.initialData!.minute}"
                            : "${date.hour}:${date.minute}",
                radius: 6,
                flagColorBackground: false,
                color: Colors.black),
          ),
        );
        // else return Container();
      },
    );
  }
}
