import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Bloc/Badge/BadgeShiftBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mTukarShiftPage.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/TukarShift/ListPengajuanSaya.dart';
import 'package:absenkuv3/UI/Modul/TukarShift/ListPengajuanTeman.dart';
import 'package:absenkuv3/UI/Modul/TukarShift/ListTukarShiftKaryawan.dart';
import 'package:absenkuv3/UI/Modul/TukarShift/ListTukarShiftTeman.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'ListTukarShiftSaya.dart';

// ignore: must_be_immutable
class ParentTabTukarShift extends StatefulWidget {
  String? data;
  ParentTabTukarShift(this.data);

  @override
  State<ParentTabTukarShift> createState() => _ParentTabTukarShiftState();
}

class _ParentTabTukarShiftState extends State<ParentTabTukarShift> {
  GlobalKey<ScaffoldState> scaffoldKey = GlobalKey();
  int tabLength = 3;

  @override
  void initState() {
    super.initState();
    BlocProvider.of<BadgeShiftBloc>(context)
        .add(GetBadgeShift(context, scaffoldKey));
  }

  Future<bool> keluar() async {
    BlocProvider.of<NavigatorBloc>(context)
        .add(NavigateRemoveToDashboard(context));
    return false;
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder<PageTukarShiftModel>(
        future: PengaturanBahasa().tukarShift(),
        builder: (context, snapshot) {
          if(snapshot.connectionState == ConnectionState.done){
            return  BlocBuilder<AuthBloc, LoginRespon>(
                builder: (BuildContext context, LoginRespon loginRespon) {
                  return WillPopScope(
                    onWillPop: keluar,
                    child: DefaultTabController(
                      initialIndex: widget.data == '/permintaan_tukar_shift'
                          ? 3
                          : widget.data == '/pengajuan_tukar_shift'
                          ? 2
                          : widget.data == 'shift_saya'
                          ? 0
                          : 1,
                      length: loginRespon.dataLogin!.level != 3 &&
                          loginRespon.dataLogin!.level != 7
                          ? 3
                          : 4,
                      child: Scaffold(
                        backgroundColor: CustomStyle.backgroundDashboardColor,
                        appBar: AppBar(
                          centerTitle: true,
                          flexibleSpace: Image(
                            image: AssetImage(ValueImage.headerBiruDashboard),
                            fit: BoxFit.cover,
                          ),
                          leading: IconButton(
                            icon: Icon(Icons.arrow_back, color: Colors.white),
                            onPressed: () => keluar(),
                          ),
                          backgroundColor: Colors.transparent,
                          title: Text(
                            snapshot.data!.menuTukarShift!.title!,
                            style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
                          ),
                          bottom: TabBar(
                            labelPadding: EdgeInsets.all(0),
                            indicatorSize: TabBarIndicatorSize.tab,
                            indicatorWeight: 4,
                            isScrollable: true,
                            tabs: loginRespon.dataLogin!.level != 3 &&
                                loginRespon.dataLogin!.level != 7
                                ? [
                              Container(
                                width: MediaQuery.of(context).size.width / 2.5,
                                child: Tab(
                                  text: snapshot.data!.menuTukarShift!.tabJadwalSaya,
                                ),
                              ),
                              Container(
                                width: MediaQuery.of(context).size.width / 2.5,
                                child: Tab(
                                    text: loginRespon.dataLogin!.level == 3
                                        ? snapshot.data!.menuTukarShift!.tabJadwalTeman
                                        : snapshot.data!.menuTukarShift!.tabJadwalKaryawan),
                              ),
                              Stack(
                                children: [
                                  BlocBuilder<BadgeShiftBloc, BadgeShiftState>(
                                      builder: (context, state) {
                                        if (state is GetSuccess &&
                                            state.dataDashboard!.data! > 0) {
                                          return Container(
                                            width:
                                            MediaQuery.of(context).size.width / 2.7,
                                            child: Tab(
                                                child: Row(
                                                  mainAxisAlignment:
                                                  MainAxisAlignment.spaceEvenly,
                                                  children: [
                                                    Text(
                                                        loginRespon.dataLogin!.level != 3 &&
                                                            loginRespon
                                                                .dataLogin!.level !=
                                                                7
                                                            ? snapshot.data!.menuTukarShift!.tabPengajuanKaryawan!
                                                            : snapshot.data!.menuTukarShift!.tabPengajuanTeman!,
                                                        textScaleFactor: 0.9),
                                                    Container(
                                                      child: Center(
                                                          child: Text(
                                                              state.dataDashboard!.data!
                                                                  .toString(),
                                                              textScaleFactor: 1.0,
                                                              style: TextStyle(
                                                                  color: Colors.white,
                                                                  fontSize: CustomStyle
                                                                      .fontSizeSmall))),
                                                      decoration: new BoxDecoration(
                                                          color: Colors.red,
                                                          shape: BoxShape.circle),
                                                      height:
                                                      MediaQuery.of(context).size.width *
                                                          0.05,
                                                      width:
                                                      MediaQuery.of(context).size.width *
                                                          0.05,
                                                    ),
                                                  ],
                                                )),
                                          );
                                        } else
                                          return Container(
                                              width: MediaQuery.of(context).size.width /
                                                  tabLength,
                                              child: Tab(
                                                  text: loginRespon.dataLogin!.level !=
                                                      3 &&
                                                      loginRespon.dataLogin!.level !=
                                                          7
                                                      ? snapshot.data!.menuTukarShift!.tabPengajuanKaryawan
                                                      : snapshot.data!.menuTukarShift!.tabPengajuanTeman));
                                      }),
                                ],
                              ),
                            ]
                                : [
                              Container(
                                width: MediaQuery.of(context).size.width / 2.5,
                                child: Tab(
                                  text: snapshot.data!.menuTukarShift!.tabJadwalSaya,
                                ),
                              ),
                              Container(
                                width: MediaQuery.of(context).size.width / 2.5,
                                child: Tab(
                                    text: loginRespon.dataLogin!.level == 3
                                        ? snapshot.data!.menuTukarShift!.tabJadwalTeman
                                        : snapshot.data!.menuTukarShift!.tabJadwalKaryawan),
                              ),
                              Container(
                                width: MediaQuery.of(context).size.width / 2.5,
                                child: Tab(text: snapshot.data!.menuTukarShift!.tabPengajuanSaya),
                              ),
                              Stack(
                                children: [
                                  BlocBuilder<BadgeShiftBloc, BadgeShiftState>(
                                      builder: (context, state) {
                                        if (state is GetSuccess &&
                                            state.dataDashboard!.data! > 0) {
                                          return Container(
                                            width:
                                            MediaQuery.of(context).size.width / 2.7,
                                            child: Tab(
                                                child: Row(
                                                  mainAxisAlignment:
                                                  MainAxisAlignment.spaceEvenly,
                                                  children: [
                                                    Text(
                                                        loginRespon.dataLogin!.level != 3 &&
                                                            loginRespon
                                                                .dataLogin!.level !=
                                                                7
                                                            ? snapshot.data!.menuTukarShift!.tabPengajuanKaryawan!
                                                            : snapshot.data!.menuTukarShift!.tabPengajuanTeman!,
                                                        textScaleFactor: 0.9),
                                                    Container(
                                                      child: Center(
                                                          child: Text(
                                                              state.dataDashboard!.data!
                                                                  .toString(),
                                                              textScaleFactor: 1.0,
                                                              style: TextStyle(
                                                                  color: Colors.white,
                                                                  fontSize: CustomStyle
                                                                      .fontSizeSmall))),
                                                      decoration: new BoxDecoration(
                                                          color: Colors.red,
                                                          shape: BoxShape.circle),
                                                      height:
                                                      MediaQuery.of(context).size.width *
                                                          0.05,
                                                      width:
                                                      MediaQuery.of(context).size.width *
                                                          0.05,
                                                    ),
                                                  ],
                                                )),
                                          );
                                        } else
                                          return Container(
                                              width: MediaQuery.of(context).size.width /
                                                  tabLength,
                                              child: Tab(
                                                  text: loginRespon.dataLogin!.level !=
                                                      3 &&
                                                      loginRespon.dataLogin!.level !=
                                                          7
                                                      ? snapshot.data!.menuTukarShift!.tabPengajuanKaryawan
                                                      : snapshot.data!.menuTukarShift!.tabPengajuanTeman));
                                      }),
                                ],
                              ),
                            ],
                          ),
                        ),
                        body: TabBarView(
                          physics: NeverScrollableScrollPhysics(),
                          children: loginRespon.dataLogin!.level != 3 &&
                              loginRespon.dataLogin!.level != 7
                              ? [
                            ListTukarShiftSaya(snapshot.data!),
                            loginRespon.dataLogin!.level != 3
                                ? ListTukarShiftKaryawan(snapshot.data!)
                                : ListTukarShiftTeman(snapshot.data!),
                            ListPengajuanTeman(snapshot.data!),
                          ]
                              : [
                            ListTukarShiftSaya(snapshot.data!),
                            loginRespon.dataLogin!.level != 3
                                ? ListTukarShiftKaryawan(snapshot.data!)
                                : ListTukarShiftTeman(snapshot.data!),
                            ListPengajuanSaya(snapshot.data!),
                            ListPengajuanTeman(snapshot.data!),
                          ],
                        ),
                      ),
                    ),
                  );
                });
          }else{
            return CircularProgressIndicator(strokeWidth: 8);
          }
        }
    );
  }
}
