import 'package:absenkuv3/Bloc/Dropdown/DropdownKlienBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/Akun/mDataDiri.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mSosPage.dart';
import 'package:absenkuv3/Repository/Model/mSos.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class CardSos extends StatelessWidget {
  final DataSo data;
  final MenuSos? redaksional;
  CardSos(this.data, this.redaksional);

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: () => BlocProvider.of<NavigatorBloc>(context)
          .add(NavigateToDetailSos(context, [data.idSos.toString()])),
      child: Container(
        margin: EdgeInsets.only(top: 12),
        child: Stack(
          children: [
            Container(
              margin: EdgeInsets.only(left: 12, right: 12),
              width: MediaQuery.of(context).size.width,
              decoration: CustomStyle.boxDecoration,
              child: Container(
                margin: EdgeInsets.only(top: 44),
                padding: EdgeInsets.only(bottom: 16),
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Padding(
                      padding: EdgeInsets.only(left: 6, right: 6, top: 4),
                      child: Divider(
                        thickness: 1,
                      ),
                    ),
                    Padding(
                        padding: EdgeInsets.only(left: 16, right: 16, top: 2),
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            TemplateColumn(
                                title: redaksional!.data!.oleh,
                                value: data.nama),
                            SizedBox(
                              height: 5,
                            ),
                            TemplateColumn(
                                title: redaksional!.data!.keterangan,
                                value: data.keterangan),
                          ],
                        ))
                  ],
                ),
              ),
            ),
            Container(
              margin: EdgeInsets.only(left: 24, right: 24, top: 6),
              height: 44,
              width: MediaQuery.of(context).size.width,
              child: Row(
                children: [
                  Icon(
                    Icons.calendar_month,
                    size: 28,
                  ),
                  SizedBox(
                    width: 8,
                  ),
                  TemplateColumn(
                    title: redaksional!.data!.tanggal,
                    value: data.tanggal.toString(),
                  )
                ],
              ),
            ),
          ],
        ),
      ),
    );
  }
}

class TemplateColumn extends StatelessWidget {
  final String? title;
  final String? value;
  TemplateColumn({super.key, this.title, this.value});

  @override
  Widget build(BuildContext context) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Text(
          title!,
          style: TextStyle(
              fontSize: 12,
              fontWeight: FontWeight.w400,
              color: CustomStyle.fontColorGrey),
        ),
        SizedBox(
          height: 8,
        ),
        Text(
          value!,
          style: TextStyle(
              fontSize: 12,
              fontWeight: FontWeight.w600,
              color: CustomStyle.fontColorBlack),
        ),
      ],
    );
  }
}

class KlienDropdownTriggerSection extends StatefulWidget {
  final Function(JenisData)? onSelected;

  const KlienDropdownTriggerSection({super.key, this.onSelected});

  @override
  State<KlienDropdownTriggerSection> createState() => _KlienDropdownTriggerSectionState();
}

class _KlienDropdownTriggerSectionState extends State<KlienDropdownTriggerSection> {
  bool _triggered = false;

  @override
  void didChangeDependencies() {
    super.didChangeDependencies();
    if (!_triggered) {
      _triggered = true;
      WidgetsBinding.instance.addPostFrameCallback((_) {
        BlocProvider.of<DropdownKlienBloc>(context).add(GetDataDropdowKlien());
      });
    }
  }

@override
Widget build(BuildContext context) {
  return BlocListener<DropdownKlienBloc, DropdownKlienState>(
    listener: (BuildContext context, DropdownKlienState state) {
      if (state is DropdownKlienSuccessState) {
        final List<JenisData> listData = state.dropdownRespon.data!;

        if (state.selectedValue == null && listData.isNotEmpty) {
          final JenisData selected = listData[0];
          if (widget.onSelected != null) {
            widget.onSelected!(selected);
          }

          BlocProvider.of<DropdownKlienBloc>(context).add(
            SelectDataDropdownKlien(selected),
          );
        }
      }
    },
    child: Container(),
  );
}

}

