import 'package:absenkuv3/Bloc/Sos/SosBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mSosPage.dart';
import 'package:absenkuv3/Repository/Model/mSos.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Sos/komponen/KomponenSos.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanListSos extends StatefulWidget {
  const HalamanListSos({super.key});

  @override
  State<HalamanListSos> createState() => _HalamanListSosState();
}

class _HalamanListSosState extends State<HalamanListSos> {
  GlobalKey<ScaffoldState> scaffoldKey = GlobalKey();
  ScrollController _scrollController = new ScrollController();

  @override
  void initState() {
    BlocProvider.of<SosBloc>(context).add(getListSosEvent(context, null));
    _scrollController.addListener(() => BlocProvider.of<SosBloc>(context)
        .add(loadMoreEvent(context, scaffoldKey, _scrollController)));
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder<PageSosModel>(
      future: PengaturanBahasa().sos(),
      builder: (BuildContext context, snapshot) {
        if (snapshot.connectionState == ConnectionState.done) {
          return Scaffold(
            key: scaffoldKey,
            backgroundColor: Colors.white,
            appBar: AppBar(
              centerTitle: true,
              title: Text(
                snapshot.data!.menuSos!.title!.parentTitle!,
                style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
              ),
              flexibleSpace: Image(
                image: AssetImage(ValueImage.headerBiruDashboard),
                fit: BoxFit.cover,
              ),
              backgroundColor: Colors.transparent,
            ),
            body: Stack(children: [
              BlocBuilder<SosBloc, SosState>(
                  builder: (BuildContext context, SosState state) {
                if (state is getListSosSuccessState ||
                    state is LoadMoreProgressState) {
                  return Stack(
                    children: [
                      ListView.builder(
                          physics: AlwaysScrollableScrollPhysics(),
                          controller: _scrollController,
                          itemCount: state.data!.length,
                          itemBuilder: (BuildContext context, index) {
                            DataSo data = state.data![index];
                            return CardSos(data,snapshot.data!.menuSos);
                          }),
                      state is LoadMoreProgressState
                          ? Positioned(
                              bottom: 16,
                              child: Container(
                                  width: MediaQuery.of(context).size.width,
                                  child: Center(
                                      child: CircularProgressIndicator(
                                    strokeWidth: 8,
                                  ))))
                          : Container(),
                    ],
                  );
                } else if (state is SosProgressState) {
                  return Center(
                    child: CircularProgressIndicator(
                      strokeWidth: 8,
                    ),
                  );
                } else {
                  return Center(
                    child: Image.asset(
                      ValueImage.noData,
                      height: 250,
                    ),
                  );
                }
              })
            ]),
          );
        } else {
          return Container();
        }
      },
    );
  }
}
