import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Bloc/Sos/DetailSosBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mSosPage.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanDetailSos extends StatefulWidget {
  var data;
  HalamanDetailSos(this.data);

  @override
  State<HalamanDetailSos> createState() => _HalamanDetailSosState();
}

class _HalamanDetailSosState extends State<HalamanDetailSos> {
  @override
  void initState() {
    print(widget.data[0]);
    BlocProvider.of<DetailSosBloc>(context).add(GetDetailSos(widget.data[0]));
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder<PageSosModel>(
      future: PengaturanBahasa().sos(),
      builder: (BuildContext context, snapshot) {
        if (snapshot.connectionState == ConnectionState.done) {
          return Scaffold(
              backgroundColor: Colors.white,
              appBar: AppBar(
                centerTitle: true,
                title: Text(
                  snapshot.data!.menuSos!.title!.parentTitle!,
                  style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
                ),
                flexibleSpace: Image(
                  image: AssetImage(ValueImage.headerBiruDashboard),
                  fit: BoxFit.cover,
                ),
                backgroundColor: Colors.transparent,
              ),
              body: BlocBuilder<DetailSosBloc, DetailSosState>(
                builder: (BuildContext context, DetailSosState state) {
                  if (state is DetailSosSuccess) {
                    return Stack(
                      children: [
                        Container(
                          height: double.infinity,
                          child: SingleChildScrollView(
                            child: Padding(
                              padding:
                                  const EdgeInsets.fromLTRB(16, 18, 16, 16),
                              child: Column(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  Row(
                                    children: [
                                      Icon(
                                        Icons.calendar_month,
                                        size: 28,
                                      ),
                                      SizedBox(
                                        width: 8,
                                      ),
                                      TemplateColumn(
                                        title: snapshot.data!.menuSos!.data!.tanggal,
                                        value: state.sosRespon.dataSos![0].tanggal,
                                      )
                                    ],
                                  ),
                                  SizedBox(
                                    height: 8,
                                  ),
                                  Divider(
                                    thickness: 1,
                                  ),
                                  SizedBox(
                                    height: 4,
                                  ),
                                  // Text(
                                  //   "${snapshot.data!.menuSos!.data!.oleh} ${state.sosRespon.dataSos![0].nama}",
                                  //   style: TextStyle(
                                  //       fontWeight: FontWeight.w600,
                                  //       color: CustomStyle.fontColorGrey,
                                  //       fontSize:
                                  //           CustomStyle.fontSizeSmall - 1),
                                  // ),
                                  TemplateColumn(
                                    title: snapshot.data!.menuSos!.data!.oleh,
                                    value:state.sosRespon.dataSos![0].nama
                                  ),
                                  SizedBox(
                                    height: 16,
                                  ),
                                  TemplateColumn(
                                    title: snapshot.data!.menuSos!.data!.keterangan,
                                    value:state.sosRespon.dataSos![0].keterangan
                                  ), 
                                  SizedBox(
                                    height: 12,
                                  ),
                                  state.sosRespon.dataSos![0].listImage !=
                                              null &&
                                          state.sosRespon.dataSos![0].listImage!
                                                  .length >
                                              0
                                      ? Wrap(
                                          spacing: 8,
                                          runSpacing: 4,
                                          children: state
                                              .sosRespon.dataSos![0].listImage!
                                              .map((item) => item.file != '-'
                                                  ? GestureDetector(
                                                      onTap: () => BlocProvider
                                                              .of<NavigatorBloc>(
                                                                  context)
                                                          .add(
                                                              NavigateToDetailImageClicked(
                                                                  context,
                                                                  item.file)),
                                                      child: Image.network(
                                                        item.file!,
                                                        width: MediaQuery.of(
                                                                    context)
                                                                .size
                                                                .width /
                                                            4,
                                                      ))
                                                  : Container())
                                              .toList(),
                                        )
                                      : Container(
                                          width:
                                              MediaQuery.of(context).size.width,
                                          child: Column(
                                            crossAxisAlignment:
                                                CrossAxisAlignment.center,
                                            children: [
                                              Icon(
                                                Icons.image_not_supported,
                                                color: Colors.grey[500],
                                                size: MediaQuery.of(context)
                                                        .size
                                                        .width /
                                                    3.2,
                                              ),
                                              SizedBox(
                                                height: 14,
                                              ),
                                              Text(
                                                "Tidak ada lampiran gambar",
                                                style: TextStyle(
                                                    color: CustomStyle
                                                        .fontColorGrey,
                                                    fontSize: CustomStyle
                                                        .fontSizeSmall,
                                                    fontWeight:
                                                        FontWeight.w400),
                                              )
                                            ],
                                          ),
                                        ),
                                ],
                              ),
                            ),
                          ),
                        )
                      ],
                    );
                  } else if (state is DetailSosProgress) {
                    return Container(
                        height: MediaQuery.of(context).size.height,
                        child: Center(
                            child: CircularProgressIndicator(
                          strokeWidth: 8,
                        )));
                  } else {
                    return Container();
                  }
                },
              ));
        } else {
          return Container();
        }
      },
    );
  }
}

class TemplateColumn extends StatelessWidget {
  final String? title;
  final String? value;
  TemplateColumn({super.key, this.title, this.value});

  @override
  Widget build(BuildContext context) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Text(
          title!,
          style: TextStyle(
              fontSize: 12,
              fontWeight: FontWeight.w400,
              color: CustomStyle.fontColorGrey),
        ),
        SizedBox(
          height: 8,
        ),
        Text(
          value!,
          style: TextStyle(
              fontSize: 12,
              fontWeight: FontWeight.w600,
              color: CustomStyle.fontColorBlack),
        ),
      ],
    );
  }
}
