import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mShiftPage.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Shift/ListShiftKaryawan.dart';
import 'package:absenkuv3/UI/Modul/Shift/ListShiftTeman.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'ListShiftSaya.dart';

class ParentTabShift extends StatelessWidget {
  final int tabLength = 2;
  @override
  Widget build(BuildContext context) {
    return FutureBuilder<PageShiftModel>(
        future: PengaturanBahasa().shift(),
        builder: (context, snapshot) {
          if(snapshot.connectionState == ConnectionState.done){
            return BlocBuilder<AuthBloc, LoginRespon>(
                builder: (BuildContext context, LoginRespon loginRespon) {
                  return DefaultTabController(
                    length: tabLength,
                    child: Scaffold(
                      backgroundColor: CustomStyle.backgroundDashboardColor,
                      appBar: AppBar(
                        centerTitle: true,
                        flexibleSpace: Image(
                          image: AssetImage(ValueImage.headerBiruDashboard),
                          fit: BoxFit.cover,
                        ),
                        backgroundColor: Colors.transparent,
                        title: Text(
                          snapshot.data!.menuShift!.title!,
                          style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
                        ),
                        bottom: TabBar(
                          labelPadding: EdgeInsets.all(0),
                          indicatorSize: TabBarIndicatorSize.tab,
                          indicatorWeight: 3,
                          isScrollable: true,
                          tabs: [
                            Container(
                              width: MediaQuery.of(context).size.width / tabLength,
                              child: Tab(
                                text: snapshot.data!.menuShift!.tabJadwalSaya,
                              ),
                            ),
                            Container(
                              width: MediaQuery.of(context).size.width / tabLength,
                              child: Tab(
                                text: loginRespon.dataLogin!.level == 3
                                    ? snapshot.data!.menuShift!.tabJadwalTeman
                                    : snapshot.data!.menuShift!.tabJadwalKaryawan,
                              ),
                            ),
                          ],
                        ),
                      ),
                      body: /*Column(
                children: [
                  Container(
                    padding: EdgeInsets.all(12),
                    color: Colors.white,
                    child: Row(
                      children: [
                        Image.asset(ValueImage.iconTukarShift, height: 56,),
                        SizedBox(width: 4,),
                        Expanded(
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Text("Ingin Tukar Shift ?", style: TextStyle(fontSize: CustomStyle.fontSizeSmall, fontWeight: FontWeight.w700, color: CustomStyle.fontColorBlack),),
                              SizedBox(height: 2,),
                              Text("Fitur untuk bertukar shift dengan teman satu Divisi atau Departemen", style: TextStyle(fontSize: CustomStyle.fontSizeSmall-2, color: CustomStyle.fontColorGrey),)
                            ],
                          ),
                        ),
                        SizedBox(width: 4,),
                        TemplateButton(
                          onClick: ()=>BlocProvider.of<NavigatorBloc>(context)
                              .add(NavigateToPengajuanTukarShift(context, null)),
                            label: "Ajukan",
                            icon: Icons.chevron_right,
                            paddingLeftRight: 18,
                            paddingTopBottom: 8,
                            borderColor: Colors.transparent,
                            gradient: LinearGradient(
                            begin: Alignment.centerLeft,
                            end: Alignment.centerRight,
                            stops: [ 0.0,0.5,1.0],
                            colors: [
                              Colors.orange[600],
                              Colors.orange[300],
                              Colors.orange[600],
                            ])),
                      ],
                    ),
                  ),
                  SizedBox(height: 8,),
                  Container(
                    color: Colors.white,
                    child: TabBar(
                      labelColor: CustomStyle.fontColorBlack,
                      labelPadding: EdgeInsets.all(0),
                      indicatorSize: TabBarIndicatorSize.tab,
                      indicatorWeight: 3,
                      isScrollable: true,
                      tabs: [
                        Container(
                          width: MediaQuery.of(context).size.width / tabLength,
                          child: Tab(
                            text: "Jadwal Saya",
                          ),
                        ),
                        Container(
                          width: MediaQuery.of(context).size.width / tabLength,
                          child: Tab(
                            text: "Jadwal Teman",
                          ),
                        ),
                      ],
                    ),
                  ),
                  Expanded(
                    child: TabBarView(
                      children: [
                        ListShiftSaya(),
                        ListShiftTeman(),
                      ],
                    ),
                  ),
                ],
              )*/
                      TabBarView(
                        physics: NeverScrollableScrollPhysics(),
                        children: [
                          ListShiftSaya(snapshot.data!),
                          loginRespon.dataLogin!.level == 3
                              ? ListShiftTeman(snapshot.data!)
                              : ListShiftKaryawan(snapshot.data!),
                        ],
                      ),
                    ),
                  );
                });
          }else{
            return CircularProgressIndicator(strokeWidth: 8);
          }
        }
    );
  }
}
