import 'package:absenkuv3/Bloc/Shift/ShiftTemanBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mShiftPage.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Shift/KomponenShift.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/Bloc/DateRangePickerBloc.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/UI/templateDateRangePicker.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class ListShiftTeman extends StatefulWidget {
  final PageShiftModel redaksional;
  ListShiftTeman(this.redaksional);

  @override
  _ListShiftTemanState createState() => _ListShiftTemanState();
}

class _ListShiftTemanState extends State<ListShiftTeman> {
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();
  ScrollController _scrollController = new ScrollController();

  @override
  void initState() {
    super.initState();
    BlocProvider.of<DateRangePickerBloc>(context).add(SetDate([
      DateTime(DateTime.now().year, DateTime.now().month, 1),
      DateTime(DateTime.now().year, DateTime.now().month, DateTime.now().day)
    ]));
    BlocProvider.of<DateRangePickerBloc>(context).add(SetDate([
      DateTime(DateTime.now().year, DateTime.now().month, 1),
      DateTime(DateTime.now().year, DateTime.now().month + 1, 0)
    ]));
    _scrollController.addListener(() => BlocProvider.of<ShiftTemanBloc>(context)
        .add(LoadMoreEvent(context, scaffoldKey, _scrollController)));
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: Colors.white,
      key: scaffoldKey,
      body: Stack(
        children: [
          BlocBuilder<ShiftTemanBloc, ShiftTemanState>(
              builder: (BuildContext context, ShiftTemanState state) {
            if (state is GetListShiftTemanSuccessState ||
                state is LoadMoreProgressState)
              return Stack(
                children: <Widget>[
                  ListView.builder(
                      physics: AlwaysScrollableScrollPhysics(),
                      controller: _scrollController,
                      itemCount: state.data!.length,
                      itemBuilder: (BuildContext context, index) {
                        return CardShift(
                            state.data![index], 'shiftTeman', scaffoldKey, widget.redaksional);
                      }),
                  state is LoadMoreProgressState
                      ? Positioned(
                          bottom: 16,
                          child: Container(
                              width: MediaQuery.of(context).size.width,
                              child: Center(
                                  child: CircularProgressIndicator(
                                strokeWidth: 8,
                              ))))
                      : Container(),
                ],
              );
            else if (state is ShiftTemanProgressState)
              return Center(
                child: CircularProgressIndicator(
                  strokeWidth: 8,
                ),
              );
            else
              return Center(
                child: Image.asset(
                  ValueImage.noData,
                  height: 250,
                ),
              );
          }),
          Positioned(
            bottom: 16,
            right: 14,
            child: BlocListener<DateRangePickerBloc, DateRangePickerState>(
              listener: (BuildContext context,
                  DateRangePickerState dateRangePickerState) {
                if (dateRangePickerState is DateAvailable)
                  BlocProvider.of<ShiftTemanBloc>(context).add(
                      GetListShiftTemanEvent(context,
                          ModelFilter(dateRange: dateRangePickerState.date)));
              },
              child: TemplateDateRangePicker(
                firstDate:
                    DateTime(DateTime.now().year, DateTime.now().month - 3, 1),
                lastDate:
                    DateTime(DateTime.now().year, DateTime.now().month + 3, 0),
              ),
            ),
          ),
        ],
      ),
    );
  }
}
