import 'package:absenkuv3/Bloc/Shift/ShiftBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mShiftPage.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/Bloc/DateRangePickerBloc.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/UI/templateDateRangePicker.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import 'KomponenShift.dart';

class ListShiftSaya extends StatefulWidget {
  final PageShiftModel redaksional;
  ListShiftSaya(this.redaksional);

  @override
  _ListShiftSayaState createState() => _ListShiftSayaState();
}

class _ListShiftSayaState extends State<ListShiftSaya> {
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();
  ScrollController _scrollController = new ScrollController();

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    BlocProvider.of<DateRangePickerBloc>(context).add(SetDate([DateTime(DateTime.now().year,DateTime.now().month, 1),DateTime(DateTime.now().year, DateTime.now().month+1,0)]));
    // BlocProvider.of<DateRangePickerBloc>(context).add(SetDate());
    _scrollController.addListener(()=>BlocProvider.of<ShiftBloc>(context).add(loadMoreEvent(context, scaffoldKey, _scrollController)));
  }
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: Colors.white,
      key: scaffoldKey,
      body: Stack(
        children: [
          BlocBuilder<ShiftBloc, ShiftState>(
              builder: (BuildContext context, ShiftState state){
                if(state is getListShiftSuccessState || state is LoadMoreProgressState)
                  return Stack(
                    children: <Widget>[
                      ListView.builder(
                          physics: AlwaysScrollableScrollPhysics(),
                          controller: _scrollController,
                          itemCount: state.data!.length,
                          itemBuilder: (BuildContext context, index) {
                            return CardShift(state.data![index], 'shiftSaya', scaffoldKey, widget.redaksional);
                          }
                      ),
                      state is LoadMoreProgressState? Positioned(
                          bottom :16,
                          child: Container(
                              width: MediaQuery.of(context).size.width,
                              child: Center(child: CircularProgressIndicator(strokeWidth: 8,)))):Container(),
                    ],
                  );
                else if(state is ShiftProgressState) return Center(child: CircularProgressIndicator(strokeWidth: 8,),);
                else return Center(child: Image.asset(ValueImage.noData, height: 250,),);
              }),
          Positioned(
            bottom: 16,
            right: 14,
            child: BlocListener<DateRangePickerBloc, DateRangePickerState>(
              listener: (BuildContext context, DateRangePickerState dateRangePickerState){
                if(dateRangePickerState is DateAvailable) BlocProvider.of<ShiftBloc>(context).add(getListShiftEvent(context, ModelFilter(dateRange: dateRangePickerState.date)));
              },
              child: TemplateDateRangePicker(firstDate: DateTime(DateTime.now().year,DateTime.now().month-3, 1),lastDate: DateTime(DateTime.now().year, DateTime.now().month+3,0),),
            ),
          ),
        ],
      ),
    );
  }
}


