import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/Bloc/Shift/PilihShiftBloc.dart';
import 'package:absenkuv3/Bloc/Shift/ShiftBloc.dart';
import 'package:absenkuv3/Bloc/Shift/TukarShiftBloc.dart' as tukarshiftbloc;
import 'package:absenkuv3/Repository/Model/PageModel/mShiftPage.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mShift2.dart';
import 'package:absenkuv3/Repository/Model/mShiftTeman.dart';
import 'package:absenkuv3/Repository/Model/mTukarShift.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:absenkuv3/UI/Template/templateForm.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';
class CardShift extends StatefulWidget {
  final DataShift data;
  final String konteks;
  final GlobalKey<ScaffoldState> scaffoldKey;
  final PageShiftModel redaksional;
  CardShift(this.data, this.konteks, this.scaffoldKey, this.redaksional);

  @override
  _CardShiftState createState() => _CardShiftState();
}

class _CardShiftState extends State<CardShift> {
  @override
  Widget build(BuildContext context) {
    String tgl = widget.data.tanggalRaw!;
    DateTime dateTime = DateTime.parse(tgl);
    String hariSingkat = DateFormat('EE', widget.redaksional.menuShift!.locale).format(dateTime);
    String month = DateFormat('MMM').format(dateTime);
    // String? convertMonthNumberToAbbreviation(String monthNumber) {
    //   Map<String, String> monthAbbreviations = {
    //     '01': 'JAN',
    //     '02': 'FEB',
    //     '03': 'MAR',
    //     '04': 'APR',
    //     '05': 'MAY',
    //     '06': 'JUN',
    //     '07': 'JUL',
    //     '08': 'AUG',
    //     '09': 'SEP',
    //     '10': 'OCT',
    //     '11': 'NOV',
    //     '12': 'DEC',
    //   };
    //   if (monthAbbreviations.containsKey(monthNumber)) {
    //     return monthAbbreviations[monthNumber];
    //   } else {
    //     return 'Invalid Month';
    //   }
    // }

    // debugPrint(convertMonthNumberToAbbreviation(month));
    return Container(
        padding: EdgeInsets.fromLTRB(12, 16, 12, 16),
        decoration: CustomStyle.boxDecoration,
        margin: EdgeInsets.only(top: 8, right: 10, left: 10),
        child: Column(
          children: [
            Row(
              mainAxisAlignment: MainAxisAlignment.spaceEvenly,
              children: [
                Column(
                  children: [
                    Text(
                      hariSingkat.toUpperCase(),
                      style: TextStyle(
                          fontSize: 12,
                          color: CustomStyle.fontColorGrey,
                          fontWeight: FontWeight.w400),
                    ),
                    SizedBox(
                      height: 2,
                    ),
                    Text(DateFormat('dd').format(dateTime),
                        style: TextStyle(
                            fontSize: 16, fontWeight: FontWeight.w600,
                            // color: CustomStyle.fontColorGrey
                            )),
                    SizedBox(
                      height: 2,
                    ),
                    Text(month,
                        style: TextStyle(
                            fontSize: 12,
                            color: CustomStyle.fontColorGrey,
                            fontWeight: FontWeight.w400)),
                  ],
                ),
                // Container(
                //   width: MediaQuery.of(context).size.width * 0.2,
                //   child: Center(
                //     child: Text(
                //       widget.data.tanggal!,
                //       maxLines: 3,
                //       style: TextStyle(
                //         fontSize: CustomStyle.fontSizeSmall,
                //         // fontWeight: FontWeight.w700,
                //         color: CustomStyle.fontColorBlack,
                //       ),
                //     ),
                //   ),
                // ),
                SizedBox(
                  width: 20,
                ),
                VerticalDividerWidget(
                  color: Colors.grey,
                  height: 50,
                ),
                SizedBox(
                  width: 20,
                ),
                Expanded(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Text(
                        widget.data.kodeShift! + ' - ' + widget.data.namaShift!,
                        style: TextStyle(
                            // fontSize: CustomStyle.fontSizeNormal,
                            fontWeight: FontWeight.w600,
                               fontSize: CustomStyle.fontSizeNormal,
                                        color: CustomStyle.fontColorBlack),
                      ),
                      SizedBox(
                        height: 5,
                      ),
                      Text(
                        widget.data.jamMasuk! +
                            ' - ' +
                            widget.data.jamPulang!,
                        style: TextStyle(
                            fontSize: CustomStyle.fontSizeSmall,
                              //  fontSize: CustomStyle.fontSizeSmall-1,
                                        color: CustomStyle.fontColorGrey),
                      ),
                      SizedBox(
                        height: 5,
                      ),
                      widget.konteks == 'shiftTeman' ||
                              widget.konteks == 'shiftKaryawan'
                          ? Text(
                            widget.data.nik.toString()+' - '+  widget.data.namaLengkap.toString(),
                              style: TextStyle(
                                  fontSize: CustomStyle.fontSizeSmall,
                                  fontWeight: FontWeight.w600,
                                  color: CustomStyle.fontColorGrey),
                            )
                          : Container()
                    ],
                  ),
                ),
                // Column(
                //   mainAxisAlignment: MainAxisAlignment.center,
                //   children: [
                //     widget.data.button == true
                //         ? TemplateButton(
                //             radius: 15,
                //             bold: false,
                //             color: Colors.green,
                //             contentColor: Colors.white,
                //             expandText: false,
                //             label: 'Tukar Shift',
                //             onClick: () {
                //               Datum dataShiftHariIni = Datum(
                //                 namaLengkap: '',
                //                 nik: '',
                //                 tglShift: widget.data.tanggalRaw!,
                //                 kodeShift: widget.data.kodeShift!,
                //                 namaShift: widget.data.namaShift!,
                //                 masuk: widget.data.jamMasuk!,
                //                 pulang: widget.data.jamPulang!,
                //               );
                //               widget.konteks == 'shiftSaya'
                //                   ? {
                //                       BlocProvider.of<
                //                               tukarShift
                //                               .TukarShiftBloc>(context)
                //                           .add(
                //                               tukarShift.getListShiftTemanEvent(
                //                                   context,
                //                                   widget.data.tanggalRaw!,
                //                                   '')),
                //                       showModalBottomSheet(
                //                         context: context,
                //                         builder: (BuildContext context) {
                //                           return MultiBlocProvider(
                //                             providers: [
                //                               BlocProvider(
                //                                 create: (context) =>
                //                                     TukarShiftBloc(
                //                                         TukarShiftProgressState()),
                //                               ),
                //                               BlocProvider(
                //                                 create: (context) =>
                //                                     PilihShiftBloc(
                //                                         DataShiftProgress()),
                //                               ),
                //                             ],
                //                             child:
                //                                 // widget.konteks=='shiftSaya'?
                //                                 BottomSheetContent(
                //                                     widget.data.tanggalRaw,
                //                                     widget.scaffoldKey,
                //                                     widget.formKey,
                //                                     dataShiftHariIni),
                //                             // :
                //                             // BottomSheetContentSendiri(
                //                             // widget.data.tanggalRaw,
                //                             // widget.scaffoldKey,
                //                             // widget.formKey,
                //                             // dataShiftHariIni)
                //                           );
                //                         },
                //                       ),
                //                     }
                //                   : {
                //                                           BlocProvider.of<
                //                               tukarShift
                //                                   .TukarShiftBloc>(context)
                //                           .add(tukarShift
                //                               .getListShiftSendiriEvent(context,
                //                                   widget.data.tanggalRaw!)),
                //                     openDialogKeterangan(
                //                       context,
                //                       ModelTukarShift(widget.data.tanggalRaw!, '', '', '', '', widget.data.idKaryawan,
                //                           widget.data.kodeShift, widget.data.namaShift, widget.data.jamMasuk, widget.data.jamPulang, ''),
                //                       widget.scaffoldKey,
                //                       widget.formKey),
                                      
                //                       };
                //               //     BlocProvider.of<tukarShift.TukarShiftBloc>(context)
                //               // .add(tukarShift.getListShiftSendiriEvent(
                //               //     context, widget.data.tanggalRaw!,));

                //               // openDialog(
                //               //     context,
                //               //     widget.data.tanggalRaw!,
                //               //     widget.data.kodeShift!,
                //               //     widget.data.namaShift!,
                //               //     widget.data.jamMasuk!,
                //               //     widget.data.jamPulang!,
                //               //     'tukar-shift',
                //               //     widget.scaffoldKey,
                //               //     widget.formKey);
                //             })
                //         : Container(),
                //   ],
                // )

                // SizedBox(width: 4,),
                // Icon(
                //   Icons.watch_later_outlined,
                //   color: Colors.grey[400],
                //   size: 35,
                // ),
                // SizedBox(width: 4,),
                // Column(
                //   crossAxisAlignment: CrossAxisAlignment.start,
                //   children: [
                //     Text(widget.data.namaShift!, style: TextStyle(fontSize: CustomStyle.fontSizeSmall, color: CustomStyle.fontColorGrey),),
                //     SizedBox(height: 2,),
                //     Text("${widget.data.jamMasuk} - ${widget.data.jamPulang}", style: TextStyle(fontSize: CustomStyle.fontSizeSmall,fontWeight: FontWeight.w700, color: CustomStyle.fontColorBlack),)
                //   ],
                // ),
              ],
            ),
            // widget.konteks == 'shiftTeman'
            //     ? Column(
            //         children: [
            //           SizedBox(
            //             height: 14,
            //           ),
            //           TemplateButton(
            //             onClick: () => BlocProvider.of<NavigatorBloc>(context)
            //                 .add(NavigateToDetailShiftTeman(
            //                     context, widget.data)),
            //             label: "Detail",
            //             expand: true,
            //           ),
            //         ],
            //       )
            //     : Container(),
            // widget.konteks == 'shiftKaryawan'
            //     ? Column(
            //         children: [
            //           SizedBox(
            //             height: 14,
            //           ),
            //           TemplateButton(
            //             onClick: () => BlocProvider.of<NavigatorBloc>(context)
            //                 .add(NavigateToDetailShiftKaryawan(
            //                     context, widget.data)),
            //             label: "Detail",
            //             expand: true,
            //           ),
            //         ],
            //       )
            //     : Container()
            /*widget.konteks=='shiftTeman'?Column(
              children: [
                SizedBox(height: 4,),
                Divider(thickness: 1,),
                SizedBox(height: 4,),
                GestureDetector(
                  onTap: ()=>BlocProvider.of<NavigatorBloc>(context).add(NavigateToPengajuanTukarShift(context, widget.data.idMasterShift)),
                  child: Row(
                    mainAxisAlignment: MainAxisAlignment.center,
                    children: [
                      Icon(Icons.wifi_protected_setup, size: 19, color: CustomStyle.color1,),
                      SizedBox(width: 2,),
                      Text('Tukar Shift', style: TextStyle(fontSize: CustomStyle.fontSizeSmall, color: CustomStyle.color1, fontWeight: FontWeight.w600),)

                    ],
                  ),
                )
              ],
            ):Container()*/
          ],
        ));
  }
}

class VerticalDividerWidget extends StatelessWidget {
  final double height;
  final Color color;

  VerticalDividerWidget({this.height = 16.0, this.color = Colors.grey});

  @override
  Widget build(BuildContext context) {
    return Container(
      height: height,
      width:
          1.0, // You can adjust the width to control the thickness of the divider
      color: color,
    );
  }
}

class CardShiftDetail extends StatefulWidget {
 final DataShiftTeman data;
  final String konteks;
 final GlobalKey<ScaffoldState> scaffoldKey;
 CardShiftDetail(this.data, this.scaffoldKey, this.konteks);

  @override
  _CardShiftDetailState createState() => _CardShiftDetailState();
}

class _CardShiftDetailState extends State<CardShiftDetail> {
  @override
  Widget build(BuildContext context) {
    return Container(
        padding: EdgeInsets.all(12),
        decoration: CustomStyle.boxDecoration,
        margin: EdgeInsets.only(top: 8, right: 10, left: 10),
        child: Row(
          children: [
            Container(
              decoration: new BoxDecoration(
                  color: Colors.grey[100],
                  borderRadius: new BorderRadius.all(Radius.circular(120.0))),
              child: ClipRRect(
                  borderRadius: BorderRadius.circular(120.0),
                  child: widget.data.foto != null && widget.data.foto != '-'
                      ? Image.network(
                          widget.data.foto!,
                          height: 58,
                          width: 58,
                          fit: BoxFit.cover,
                        )
                      : Padding(
                          padding: const EdgeInsets.all(8.0),
                          child: Icon(
                            Icons.person,
                            color: Colors.grey[400],
                            size: 42,
                          ),
                        )),
            ),
            SizedBox(
              width: 12,
            ),
            Expanded(
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Text(
                    widget.data.namaLengkap!,
                    style: TextStyle(
                        fontSize: CustomStyle.fontSizeSmall + 1,
                        fontWeight: FontWeight.w700,
                        color: CustomStyle.fontColorBlack),
                  ),
                  SizedBox(
                    height: 3,
                  ),
                  // Text(
                  //   "${widget.data.namaJabatan} ${widget.data.namaDepartemen}",
                  //   style: TextStyle(
                  //       fontSize: CustomStyle.fontSizeSmall - 1,
                  //       color: CustomStyle.fontColorGrey),
                  // ),
                  SizedBox(
                    height: 5,
                  ),
                  // Wrap(
                  //   spacing: 4,
                  //   runSpacing: 3,
                  //   children: [
                  //     TemplateButton(
                  //       label: widget.data.namaCabang,
                  //       color: Colors.grey[300],
                  //       paddingTopBottom: 0,
                  //       heightButton: 20,
                  //       paddingLeftRight: 12,
                  //       radius: 8,
                  //       fontSize: 11,
                  //       contentColor: CustomStyle.fontColorBlack,
                  //     ),
                  //     TemplateButton(
                  //       label: widget.data.namaDepartemen,
                  //       color: Colors.grey[300],
                  //       paddingTopBottom: 0,
                  //       heightButton: 20,
                  //       paddingLeftRight: 12,
                  //       radius: 8,
                  //       fontSize: 11,
                  //       contentColor: CustomStyle.fontColorBlack,
                  //     ),
                  //   ],
                  // ),
                ],
              ),
            ),
            SizedBox(
              width: 4,
            ),
            /*widget.konteks=='shiftTeman'?TemplateButton(
               label: "Tukar Shift",
                icon: Icons.chevron_right,
                paddingLeftRight: 12,
                paddingTopBottom: 8,
                borderColor: Colors.transparent,
                gradient: LinearGradient(
                    begin: Alignment.centerLeft,
                    end: Alignment.centerRight,
                    stops: [ 0.0,0.5,1.0],
                    colors: [
                      CustomStyle.color1,
                      Colors.lightBlue,
                      CustomStyle.color1,
                    ])):Container(),*/
          ],
        ));
  }
}

openDialog(
    BuildContext context,
    String tglShift,
    String kodeShiftAwal,
    String namaShiftAwal,
    String masukAwal,
    String pulangAwal,
    String? jenis,
    GlobalKey<ScaffoldState>? scaffoldKey,
    GlobalKey<FormState>? formKey) {
  Datum? Shift;
  Shift = Datum();

  VoidCallback? handleRadioValueChange1(Datum? value) {
    BlocProvider.of<PilihShiftBloc>(context).add(SetShift(value!));
    return null;
  }

  showDialog(
      context: context,
      builder: (BuildContext context) {
        return Container(
          child: AlertDialog(
            titlePadding: EdgeInsets.zero,
            title: AppBar(
              bottomOpacity: 0,
              elevation: 0,
              automaticallyImplyLeading: false,
              title: Container(
                width: double.infinity,
                child: Center(
                  child: Text(
                    "Tukar Shift",
                    textScaleFactor: 1.0,
                    style: TextStyle(
                        color: Colors.white,
                        fontWeight: FontWeight.bold,
                        fontSize: CustomStyle.fontSizeNormal + 2),
                  ),
                ),
              ),
            ),
            content: BlocBuilder<tukarshiftbloc.TukarShiftBloc, tukarshiftbloc.TukarShiftState>(
                builder: (BuildContext context, tukarshiftbloc.TukarShiftState state) {
              if (state is tukarshiftbloc.getListShiftTemanSuccessState ||
                  state is tukarshiftbloc.LoadMorePengajuanTukarShiftSayaProgressState)
                return BlocBuilder<PilihShiftBloc, Datum>(
                    builder: (BuildContext context, Datum state2) {
                  Shift = state2;
                  return Container(
                    height: MediaQuery.of(context).size.height / 3,
                    width: MediaQuery.of(context).size.width / 3 * 2,
                    child: SingleChildScrollView(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.stretch,
                        children: [
                          for (int i = 0; i < state.datum!.length; i++)
                            Column(
                              crossAxisAlignment: CrossAxisAlignment.center,
                              children: [
                                Container(
                                  padding: EdgeInsets.fromLTRB(5, 10, 5, 10),
                                  decoration: BoxDecoration(
                                      border: Border.all(
                                          width: 1,
                                          color: CustomStyle.fontColorGrey!),
                                      borderRadius: new BorderRadius.all(
                                        Radius.circular(10),
                                      )),
                                  child: Row(
                                    children: [
                                      Radio<Datum?>(
                                        materialTapTargetSize:
                                            MaterialTapTargetSize.padded,
                                        value: state.datum![i],
                                        activeColor: CustomStyle.color1,
                                        groupValue: Shift,
                                        onChanged: handleRadioValueChange1,
                                      ),
                                      SizedBox(
                                        width: 20,
                                      ),
                                      Column(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        children: [
                                          Text(state.datum![i].namaShift!,
                                              textScaleFactor: 1.0,
                                              style: TextStyle(
                                                  fontWeight: FontWeight.bold)),
                                          Text(
                                              state.datum![i].masuk.toString() +
                                                  ' - ' +
                                                  state.datum![i].pulang
                                                      .toString(),
                                              textScaleFactor: 1.0,
                                              style: TextStyle(fontSize: 15)),
                                          state.datum![i].namaLengkap!.isEmpty
                                              ? Container()
                                              : Text(
                                                  state.datum![i].namaLengkap
                                                      .toString(),
                                                  textScaleFactor: 1.0,
                                                  style:
                                                      TextStyle(fontSize: 15)),
                                        ],
                                      )
                                    ],
                                  ),
                                ),
                                SizedBox(
                                  height: 10,
                                )
                              ],
                            ),
                          state.datum!.length == 1
                              ? SizedBox(
                                  height:
                                      MediaQuery.of(context).size.height / 14,
                                )
                              : SizedBox(),
                          SizedBox(
                            height: 20,
                          ),
                        ],
                      ),
                    ),
                    // state is LoadMoreTukarShiftProgressState
                    //     ? Positioned(
                    //         bottom: 16,
                    //         child: Container(
                    //             width: MediaQuery.of(context).size.width,
                    //             child: Center(
                    //                 child: CircularProgressIndicator(
                    //               strokeWidth: 8,
                    //               color: CustomStyle.color1,
                    //             ))))
                    //     : Container(),
                    // Positioned(
                    //     bottom: 5,
                    //     child: Container(
                    //       width: MediaQuery.of(context).size.width / 3 * 2,
                    //       //       width: MediaQuery.of(context).size.width,
                    //       // height: MediaQuery.of(context).size.height/10,
                    //       child: Row(
                    //         mainAxisAlignment:
                    //             MainAxisAlignment.spaceBetween,
                    //         children: [
                    //           Container(
                    //               width:
                    //                   MediaQuery.of(context).size.width / 4,
                    //               child: TemplateButton(
                    //                   radius: 10,
                    //                   bold: true,
                    //                   color: Colors.grey,
                    //                   contentColor: Colors.white,
                    //                   expandText: false,
                    //                   label: 'Kembali',
                    //                   fontSize: 13,
                    //                   onClick: () {
                    //                     Navigator.of(context).pop();
                    //                     Shift = Datum();
                    //                     state2.kodeShift = null;
                    //                   })),
                    //           SizedBox(
                    //             width: 10,
                    //           ),
                    //           Shift!.kodeShift == null ||
                    //                   state2.kodeShift == null
                    //               ? Container(
                    //                   width: MediaQuery.of(context)
                    //                           .size
                    //                           .width /
                    //                       4,
                    //                   child: TemplateButton(
                    //                       radius: 10,
                    //                       bold: true,
                    //                       color: CustomStyle.fontColorGrey,
                    //                       contentColor: Colors.white,
                    //                       expandText: false,
                    //                       label: 'Lanjutkan',
                    //                       fontSize: 13,
                    //                       onClick: () {
                    //                         showSnackBarDelayed(scaffoldKey,
                    //                             'Harus memilih shift terlebih dahulu');
                    //                       }))
                    //               : Container(
                    //                   width: MediaQuery.of(context)
                    //                           .size
                    //                           .width /
                    //                       4,
                    //                   child: TemplateButton(
                    //                       radius: 10,
                    //                       bold: true,
                    //                       color: CustomStyle.color1,
                    //                       contentColor: Colors.white,
                    //                       expandText: false,
                    //                       label: 'Lanjutkan',
                    //                       fontSize: 13,
                    //                       onClick: () {
                    //                         ModelTukarShift model =
                    //                             ModelTukarShift(
                    //                                 tglShift,
                    //                                 kodeShiftAwal,
                    //                                 namaShiftAwal,
                    //                                 masukAwal,
                    //                                 pulangAwal,
                    //                                 state2.nip,
                    //                                 state2.kodeShift,
                    //                                 state2.namaShift,
                    //                                 state2.masuk,
                    //                                 state2.pulang);
                    //                         Navigator.of(context).pop();
                    //                         openDialogKeterangan(
                    //                             context,
                    //                             model,
                    //                             scaffoldKey!,
                    //                             formKey!);
                    //                       })),
                    //         ],
                    //       ),
                    //     ))
                  );
                });
              else if (state is tukarshiftbloc.TukarShiftProgressState)
                return Container(
                  height: MediaQuery.of(context).size.height / 3,
                  width: MediaQuery.of(context).size.width / 3 * 2,
                  child: Center(
                    child: CircularProgressIndicator(
                      strokeWidth: 8,
                      color: CustomStyle.color1,
                    ),
                  ),
                );
              else
                return Center(
                  child: Image.asset(
                    ValueImage.noData,
                    height: 250,
                  ),
                );
            }),
            actions: [
              BlocBuilder<PilihShiftBloc, Datum>(
                  builder: (BuildContext context, Datum state2) {
                return Align(
                    alignment: Alignment.bottomCenter,
                    child: Container(
                      width: MediaQuery.of(context).size.width / 3 * 2,
                      child: Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          Container(
                              width: MediaQuery.of(context).size.width / 4,
                              child: TemplateButton(
                                  radius: 10,
                                  bold: true,
                                  color: Colors.grey,
                                  contentColor: Colors.white,
                                  expandText: false,
                                  label: 'Kembali',
                                  fontSize: 13,
                                  onClick: () {
                                    Navigator.of(context).pop();
                                    Shift = Datum();
                                    state2.kodeShift = null;
                                  })),
                          SizedBox(
                            width: 10,
                          ),
                          state2.kodeShift == null
                              ? Container(
                                  width: MediaQuery.of(context).size.width / 4,
                                  child: TemplateButton(
                                      radius: 10,
                                      bold: true,
                                      color: CustomStyle.fontColorGrey,
                                      contentColor: Colors.white,
                                      expandText: false,
                                      label: 'Lanjutkan',
                                      fontSize: 13,
                                      onClick: () {
                                        showSnackBarDelayed(
                                            scaffoldKey,
                                            'Harus memilih shift terlebih dahulu',
                                            context);
                                      }))
                              : Container(
                                  width: MediaQuery.of(context).size.width / 4,
                                  child: TemplateButton(
                                      radius: 10,
                                      bold: true,
                                      color: CustomStyle.color1,
                                      contentColor: Colors.white,
                                      expandText: false,
                                      label: 'Lanjutkan',
                                      fontSize: 13,
                                      onClick: () {
                                        // ModelTukarShift model = ModelTukarShift(
                                        //     tglShift,
                                        //     kodeShiftAwal,
                                        //     namaShiftAwal,
                                        //     masukAwal,
                                        //     pulangAwal,
                                        //     state2.nik,
                                        //     state2.kodeShift,
                                        //     state2.namaShift,
                                        //     state2.masuk,
                                        //     state2.pulang,
                                        //     jenis);
                                        Navigator.of(context).pop();
                                        // openDialogKeterangan(context, model,
                                        //     scaffoldKey!, formKey!);
                                      })),
                        ],
                      ),
                    ));
              })
            ],
            actionsOverflowButtonSpacing: 10,
            actionsPadding: EdgeInsets.only(bottom: 10),
            shape: RoundedRectangleBorder(
                borderRadius:
                    BorderRadius.all(Radius.circular(CustomStyle.boxRadius))),
          ),
        );
      });
}

openDialogKeterangan(BuildContext context, ModelTukarShift model,
    GlobalKey<ScaffoldState> scaffoldKey, GlobalKey<FormState> formKey) {
  TextEditingController keterangan = new TextEditingController();

  showDialog(
      context: context,
      builder: (BuildContext context) {
        return Container(
          child: AlertDialog(
            titlePadding: EdgeInsets.zero,
            title: Container(
              height: MediaQuery.of(context).size.height * 0.07,
              child: Center(
                  child: Text(
                'Tukar Shift',
                style: TextStyle(color: Colors.white),
              )),
              decoration: BoxDecoration(
                borderRadius: BorderRadius.only(
                  topLeft: Radius.circular(10.0),
                  topRight: Radius.circular(10.0),
                ),
                color: CustomStyle.color1,
              ),
            ),
            content: BlocBuilder<tukarshiftbloc.TukarShiftBloc, tukarshiftbloc.TukarShiftState>(
                builder: (BuildContext context, tukarshiftbloc.TukarShiftState state) {
              if (state is tukarshiftbloc.getListShiftTemanSuccessState ||
                  state is tukarshiftbloc.LoadMoreTukarShiftProgressState)
                return Container(
                  width: MediaQuery.of(context).size.width,
                  height: MediaQuery.of(context).size.height / 2.7,
                  child: Stack(
                    children: [
                      Column(
                          mainAxisSize: MainAxisSize.max,
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Container(
                              decoration: BoxDecoration(
                                  border: Border.all(
                                      width: 0.5,
                                      color: CustomStyle.fontColorGrey!),
                                  borderRadius: new BorderRadius.all(
                                    Radius.circular(10),
                                  )),
                              child: Padding(
                                padding: const EdgeInsets.all(8.0),
                                child: Column(
                                  children: [
                                    Row(
                                      children: [
                                        Icon(
                                          Icons.calendar_month,
                                          color: CustomStyle.fontColorGrey,
                                        ),
                                        SizedBox(
                                          width: 5,
                                        ),
                                        Container(
                                          child: Text(
                                            model.tglShift!,
                                            style: TextStyle(
                                                fontSize: CustomStyle.fontSizeSmall,
                                                fontWeight: FontWeight.w700,
                                                color: CustomStyle.fontColorGrey),
                                          ),
                                        ),
                                      ],
                                    ),
                                    SizedBox(
                                      height: 2,
                                    ),
                                    Divider(
                                      thickness: 1,
                                    ),
                                    SizedBox(
                                      height: 3,
                                    ),
                                    Row(
                                      mainAxisAlignment:
                                          MainAxisAlignment.spaceBetween,
                                      children: [
                                        Expanded(
                                          child: Column(
                                            children: [
                                              Text(
                                                'Shift Anda',
                                                style: TextStyle(
                                                    fontSize:
                                                        CustomStyle.fontSizeSmall,
                                                    fontWeight: FontWeight.w700,
                                                    color:
                                                        CustomStyle.fontColorGrey),
                                              ),
                                              SizedBox(
                                                height: 3,
                                              ),
                                              Container(
                                                padding: EdgeInsets.fromLTRB(
                                                    10, 10, 10, 10),
                                                decoration: BoxDecoration(
                                                    // color: Colors.black,
                                                    border: Border.all(
                                                        width: 0.3,
                                                        color: CustomStyle
                                                            .fontColorGrey!),
                                                    borderRadius:
                                                        new BorderRadius.all(
                                                      Radius.circular(10),
                                                    )),
                                                child: Column(
                                                  crossAxisAlignment:
                                                      CrossAxisAlignment.start,
                                                  children: [
                                                    Text(
                                                      state.datum![0].namaShift
                                                          .toString(),
                                                      textScaleFactor: 1.0,
                                                      style: TextStyle(
                                                        fontSize: CustomStyle
                                                            .fontSizeSmall,
                                                        fontWeight: FontWeight.bold,
                                                      ),
                                                    ),
                                                    SizedBox(
                                                      height: 2,
                                                    ),
                                                    Text(
                                                      state.datum![0].masuk.toString() + ' - '+state.datum![0].pulang
                                                              .toString(),
                                                      textScaleFactor: 1.0,
                                                      style: TextStyle(
                                                        fontSize: CustomStyle
                                                                .fontSizeSmall -
                                                            1,
                                                        color: CustomStyle
                                                            .fontColorGrey,
                                                      ),
                                                    ),
                                                    SizedBox(
                                                      height: 2,
                                                    ),
                                                    Text(
                                                      state.datum![0].kodeShift
                                                          .toString(),
                                                      textScaleFactor: 1.0,
                                                      style: TextStyle(
                                                        fontSize: CustomStyle
                                                                .fontSizeSmall -
                                                            1,
                                                        color: CustomStyle
                                                            .fontColorGrey,
                                                      ),
                                                    ),
                                                  ],
                                                ),
                                              ),
                                            ],
                                          ),
                                        ),
                                        SizedBox(
                                          width: 5,
                                        ),
                                        Column(
                                          children: [
                                            Icon(
                                              Icons.arrow_forward,
                                              color: CustomStyle.fontColorGrey,
                                              size: 15,
                                            ),
                                            Icon(
                                              Icons.arrow_back,
                                              color: CustomStyle.fontColorGrey,
                                              size: 15,
                                            ),
                                          ],
                                        ),
                                        SizedBox(
                                          width: 5,
                                        ),
                                        Expanded(
                                          child: Column(
                                            children: [
                                              Text(
                                                'Shift Teman',
                                                style: TextStyle(
                                                    fontSize:
                                                        CustomStyle.fontSizeSmall,
                                                    fontWeight: FontWeight.w700,
                                                    color:
                                                        CustomStyle.fontColorGrey),
                                              ),
                                              SizedBox(
                                                height: 3,
                                              ),
                                              Container(
                                                padding: EdgeInsets.fromLTRB(
                                                    10, 10, 10, 10),
                                                decoration: BoxDecoration(
                                                    border: Border.all(
                                                      width: 0.3,
                                                      color: CustomStyle
                                                          .fontColorGrey!,
                                                    ),
                                                    borderRadius:
                                                        new BorderRadius.all(
                                                      Radius.circular(10),
                                                    )),
                                                child: Column(
                                                  crossAxisAlignment:
                                                      CrossAxisAlignment.start,
                                                  children: [
                                                    Text(
                                                      model.namaShiftBaru
                                                          .toString(),
                                                      textScaleFactor: 1.0,
                                                      style: TextStyle(
                                                        fontSize: CustomStyle
                                                            .fontSizeSmall,
                                                        fontWeight: FontWeight.bold,
                                                      ),
                                                    ),
                                                    SizedBox(
                                                      height: 2,
                                                    ),
                                                    Text(
                                                      model.masukBaru.toString() +
                                                          ' - ' +
                                                          model.pulangBaru
                                                              .toString(),
                                                      textScaleFactor: 1.0,
                                                      style: TextStyle(
                                                        fontSize: CustomStyle
                                                                .fontSizeSmall -
                                                            1,
                                                        color: CustomStyle
                                                            .fontColorGrey,
                                                      ),
                                                    ),
                                                    SizedBox(
                                                      height: 2,
                                                    ),
                                                    Text(
                                                      model.kodeShiftBaru
                                                          .toString(),
                                                      textScaleFactor: 1.0,
                                                      style: TextStyle(
                                                        fontSize: CustomStyle
                                                                .fontSizeSmall -
                                                            1,
                                                        color: CustomStyle
                                                            .fontColorGrey,
                                                      ),
                                                    ),
                                                  ],
                                                ),
                                              ),
                                            ],
                                          ),
                                        ),
                                      ],
                                    ),
                                    SizedBox(
                                      height: 10,
                                    ),
                                  ],
                                ),
                              ),
                            ),
                            SizedBox(
                              height: 10,
                            ),
                            TemplateForm(
                              minLine: 2,
                              maxLine: 3,
                              formHeight: 56,
                              adaValidasi: true,
                              controller: keterangan,
                              color: CustomStyle.fontColorGrey,
                              titleText: "Keterangan",
                              radius: CustomStyle.formRadius,
                              hintText: "Keterangan",
                            ),
                          ]),
                      Positioned(
                          width: MediaQuery.of(context).size.width * 0.65,
                          bottom: 5,
                          child: Row(
                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                            // crossAxisAlignment: CrossAxisAlignment.center,
                            children: [
                              Container(
                                  width: MediaQuery.of(context).size.width / 4,
                                  child: TemplateButton(
                                      radius: 10,
                                      bold: true,
                                      color: Colors.grey,
                                      contentColor: Colors.white,
                                      expandText: false,
                                      fontSize: 13,
                                      label: 'Kembali',
                                      onClick: () {
                                        Navigator.of(context).pop();
                                      })),
                              Container(
                                  width: MediaQuery.of(context).size.width / 4,
                                  child: TemplateButton(
                                      radius: 10,
                                      bold: true,
                                      color: CustomStyle.color1,
                                      contentColor: Colors.white,
                                      fontSize: 13,
                                      expandText: false,
                                      label: 'Ajukan',
                                      onClick: () {
                                        ModelTukarShift model2 = ModelTukarShift(
                                            model.tglShift,
                                            state.datum![0].kodeShift,
                                            state.datum![0].namaShift,
                                            state.datum![0].masuk,
                                            state.datum![0].pulang,
                                            model.nipApv,
                                            model.kodeShiftBaru,
                                            model.namaShiftBaru!,
                                            model.masukBaru,
                                            model.pulangBaru,
                                            model.jenis,
                                            keterangan: keterangan.text);
                                        BlocProvider.of<ShiftBloc>(context).add(
                                            pengajuanTukarShift(
                                                model2,
                                                context,
                                                scaffoldKey,
                                                formKey,
                                                ModelFilter(),
                                                'ShiftTeman'));
                                      })),
                            ],
                          ))
                    ],
                  ),
                );else  return Container(
                  width: MediaQuery.of(context).size.width / 3 * 2,
                  height: MediaQuery.of(context).size.height / 3,
                  child: Center(child: CircularProgressIndicator(strokeWidth: 8,color: CustomStyle.color1,),),
                );
              }
            ),
            shape: RoundedRectangleBorder(
              borderRadius: BorderRadius.circular(10.0),
            ),
          ),
        );
      });
}
