import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownKabupatenBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownKecamatanBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownKelurahanBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownProvinsiBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/DropdownJenisPerusahaanBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/DropdownLeadMasterBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/DropdownSalesBawahanBloc.dart';
import 'package:absenkuv3/Repository/Model/Akun/mDataDiri.dart';
import 'package:absenkuv3/Repository/Model/mDropdown.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mPerusahaan.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/UI/Modul/Dropdown/Akun/DropdownJenisKabupaten.dart';
import 'package:absenkuv3/UI/Modul/Dropdown/Akun/DropdownJenisKecamatan.dart';
import 'package:absenkuv3/UI/Modul/Dropdown/Akun/DropdownJenisKelurahan.dart';
import 'package:absenkuv3/UI/Modul/Dropdown/Akun/DropdownJenisProvinsi.dart';
import 'package:absenkuv3/UI/Modul/Dropdown/DropdownJenisPerusahaan.dart';
import 'package:absenkuv3/UI/Modul/Dropdown/DropdownLeadMaster.dart';
import 'package:absenkuv3/UI/Modul/Dropdown/DropdownSalesBawahan.dart';
import 'package:absenkuv3/UI/Template/AutoComplete/Bloc/AutoCompletePegawaiBawahanBloc.dart';
import 'package:absenkuv3/UI/Template/AutoComplete/Bloc/AutoCompletePerusahaanBloc.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateTextFormAkun.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

typedef void DataCustomerPageCallback(DataPerusahaan? val);

class DataCustomerPage extends StatefulWidget {
  DataCustomerPageCallback? dataCallback;
  DataCustomerPage({this.dataCallback});

  @override
  State<DataCustomerPage> createState() => _DataCustomerPageState();
}

class _DataCustomerPageState extends State<DataCustomerPage> {
  SingingCharacter? _character = SingingCharacter.Perusahaan;
  TextEditingController title = TextEditingController();
  TextEditingController keterangan = TextEditingController();
  TextEditingController namaPerusahaan = TextEditingController();
  PerusahaanRespon? listDataPerusahaan;
  DataPerusahaan? dataPerusahaan;
  DataDropdown? jenisPerusahaan;
  DataDropdown? leadSource;
  JenisData? provinsi;
  JenisData? kabkota;
  JenisData? kecamatan;
  JenisData? kelurahan;
  TextEditingController alamatPerusahaan = TextEditingController();
  TextEditingController namaPICPerusahaan = TextEditingController();
  TextEditingController emailPerusahaan = TextEditingController();
  TextEditingController noTeleponPerusahaan = TextEditingController();
  bool pelangganBaru = false;
  DataDropdown? dataPegawai;

  @override
  void initState() {
    super.initState();
    BlocProvider.of<DropdownLeadMasterBloc>(context)
        .add(GetDataDropdownLeadMaster());
    BlocProvider.of<DropdownJenisPerusahaanBloc>(context).add(GetDataDropdownJenisPerusahaan(_character!.name));
    BlocProvider.of<AutoCompletePerusahaanBloc>(context)
        .add(GetPerusahaan("", _character!.name, true, null));
    BlocProvider.of<DropdownSalesBawahanBloc>(context).add(GetDataDropdownSalesBawahan(""));
  }

  @override
  Widget build(BuildContext context) {
    return Expanded(
      child: Container(
        margin: EdgeInsets.fromLTRB(27, 13, 27, 30),
        child: SingleChildScrollView(
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              BlocBuilder<AuthBloc, LoginRespon>(
                builder: (context, stateLogin) {
                  return stateLogin.dataLogin!.adminAtasan!
                      ? Column(
                          children: [
                            BlocListener<DropdownSalesBawahanBloc, DropdownSalesBawahanState>(
                              listener: (BuildContext context, DropdownSalesBawahanState stateSalesBawahan) {
                                if (stateSalesBawahan is DropdownSalesBawahanSuccessState && stateSalesBawahan.selectedValue != null) {
                                  dataPegawai = stateSalesBawahan.selectedValue;
                                  widget.dataCallback!(DataPerusahaan(
                                      idSalesBawahan: dataPegawai==null?null:dataPegawai!.id,
                                      idPelanggan: dataPerusahaan==null?null:dataPerusahaan!.idPelanggan,
                                      namaPerusahaan: namaPerusahaan.text,
                                      jenisPerusahaan: jenisPerusahaan == null ? null : JenisPerusahaan(
                                          idJenisPerusahaanM: jenisPerusahaan!.id,
                                          namaJenisPerusahaan: jenisPerusahaan!.nama
                                      ),
                                      leadSource: leadSource == null ? null : LeadSource(
                                          idLeadM: leadSource!.id,
                                          namaLeadM: leadSource!.nama
                                      ),
                                      alamat: alamatPerusahaan.text,
                                      provinsi: provinsi == null ? null : Provinsi(
                                          idProvinsi: int.parse(provinsi!.id!),
                                          namaProvinsi: provinsi!.nama
                                      ),
                                      kota: kabkota == null ? null : Kota(
                                          idKota: int.parse(kabkota!.id!),
                                          namaKota: kabkota!.nama
                                      ),
                                      kecamatan: kecamatan == null ? null : Kecamatan(
                                          idKecamatan: int.parse(kecamatan!.id!),
                                          namaKecamatan: kecamatan!.nama
                                      ),
                                      kelurahan: kelurahan == null ? null : Kelurahan(
                                          idKelurahan: int.parse(kelurahan!.id!),
                                          namaKelurahan: kelurahan!.nama
                                      ),
                                      picNama: namaPICPerusahaan.text,
                                      picEmail: emailPerusahaan.text,
                                      picTelp: noTeleponPerusahaan.text,
                                      pelangganBaru: pelangganBaru,
                                      title: title.text,
                                      keterangan: keterangan.text,
                                      kategoriPelanggan: _character!.name
                                  ));
                                }
                              },
                              child: DropdownSalesBawahan(
                                'Sales',
                                initialData: dataPegawai == null ? null : dataPegawai!.nama,
                                color: Colors.grey[600],
                                // fontSize: 16,
                                marginHorizontal: 3,
                              ),
                            )
                          ],
                        )
                      : Container();
                }
              ),
              Row(
                children: [
                  Text("Jenis Customer"),
                  SizedBox(width: 7),
                  Text("*", style: TextStyle(color: Colors.red)),
                ],
              ),
              Row(
                children: [
                  Expanded(
                    child: Container(
                      child: RadioMenuButton(
                        style: ButtonStyle(
                          padding: MaterialStateProperty.all(EdgeInsets.all(0)),
                          fixedSize: MaterialStateProperty.all(Size(3, 3)),
                          overlayColor: MaterialStateProperty.all(Colors.transparent)
                        ),
                        value: SingingCharacter.Perusahaan,
                        onChanged: (SingingCharacter? value) {
                          setState(() {
                            _character = value;
                            dataPerusahaan = null;
                            widget.dataCallback!(null);
                            pelangganBaru = true;
                            namaPerusahaan.clear();
                            jenisPerusahaan = null;
                            BlocProvider.of<DropdownJenisPerusahaanBloc>(context).add(GetDataDropdownJenisPerusahaan(_character!.name));
                            leadSource = null;
                            alamatPerusahaan.clear();
                            provinsi = null;
                            BlocProvider.of<DropdownProvinsiBloc>(context).add(GetDataDropdownProvinsi());
                            kabkota = null;
                            // BlocProvider.of<DropdownKabupatenBloc>(context).add(SetProvinsi(null, null));
                            BlocProvider.of<DropdownKabupatenBloc>(context).add(ClearDataDropdownKabupaten());
                            kecamatan = null;
                            // BlocProvider.of<DropdownKecamatanBloc>(context).add(SetKabupaten(null, null));
                            BlocProvider.of<DropdownKecamatanBloc>(context).add(ClearDataDropdownKecamatan());
                            kelurahan = null;
                            // BlocProvider.of<DropdownKelurahanBloc>(context).add(SetKecamatan(null, null));
                            BlocProvider.of<DropdownKelurahanBloc>(context).add(ClearDataDropdownKelurahan());
                            namaPICPerusahaan.clear();
                            emailPerusahaan.clear();
                            noTeleponPerusahaan.clear();
                            title.clear();
                            keterangan.clear();
                            BlocProvider.of<AutoCompletePerusahaanBloc>(context)
                                .add(GetPerusahaan("", _character!.name, true, null));
                            // widget.dataCallback!(DataPerusahaan(
                            //     idPelanggan: dataPerusahaan==null?null:dataPerusahaan!.idPelanggan,
                            //     namaPerusahaan: namaPerusahaan.text,
                            //     jenisPerusahaan: jenisPerusahaan == null ? null : JenisPerusahaan(
                            //         idJenisPerusahaanM: jenisPerusahaan!.id,
                            //         namaJenisPerusahaan: jenisPerusahaan!.nama
                            //     ),
                            //     leadSource: leadSource == null ? null : LeadSource(
                            //         idLeadM: leadSource!.id,
                            //         namaLeadM: leadSource!.nama
                            //     ),
                            //     alamat: alamatPerusahaan.text,
                            //     provinsi: provinsi == null ? null : Provinsi(
                            //         idProvinsi: int.parse(provinsi!.id!),
                            //         namaProvinsi: provinsi!.nama
                            //     ),
                            //     kota: kabkota == null ? null : Kota(
                            //         idKota: int.parse(kabkota!.id!),
                            //         namaKota: kabkota!.nama
                            //     ),
                            //     picNama: namaPICPerusahaan.text,
                            //     picEmail: emailPerusahaan.text,
                            //     picTelp: noTeleponPerusahaan.text,
                            //     title: title.text,
                            //     keterangan: keterangan.text,
                            //     pelangganBaru: pelangganBaru,
                            //     kategoriPelanggan: _character!.name
                            // ));
                          });
                        },
                        groupValue: _character,
                        child: Text("Perusahaan"),
                      ),
                    ),
                  ),
                  SizedBox(width: 13),
                  Expanded(
                    child: Container(
                      child: RadioMenuButton(
                        style: ButtonStyle(
                          fixedSize: MaterialStateProperty.all(Size(3,3)),
                          padding: MaterialStateProperty.all(EdgeInsets.all(0)),
                          enableFeedback: false,
                          overlayColor: MaterialStateProperty.all(Colors.transparent)
                        ),
                        value: SingingCharacter.Perorangan,
                        onChanged: (SingingCharacter? value) {
                          setState(() {
                            _character = value;
                            dataPerusahaan = null;
                            widget.dataCallback!(null);
                            pelangganBaru = true;
                            namaPerusahaan.clear();
                            jenisPerusahaan = null;
                            BlocProvider.of<DropdownJenisPerusahaanBloc>(context).add(GetDataDropdownJenisPerusahaan(_character!.name));
                            leadSource = null;
                            alamatPerusahaan.clear();
                            provinsi = null;
                            BlocProvider.of<DropdownProvinsiBloc>(context)
                                .add(GetDataDropdownProvinsi());
                            kabkota = null;
                            // BlocProvider.of<DropdownKabupatenBloc>(context).add(SetProvinsi(null, null));
                            BlocProvider.of<DropdownKabupatenBloc>(context).add(ClearDataDropdownKabupaten());
                            kecamatan = null;
                            // BlocProvider.of<DropdownKecamatanBloc>(context).add(SetKabupaten(null, null));
                            BlocProvider.of<DropdownKecamatanBloc>(context).add(ClearDataDropdownKecamatan());
                            kelurahan = null;
                            // BlocProvider.of<DropdownKelurahanBloc>(context).add(SetKecamatan(null, null));
                            BlocProvider.of<DropdownKelurahanBloc>(context).add(ClearDataDropdownKelurahan());
                            namaPICPerusahaan.clear();
                            emailPerusahaan.clear();
                            noTeleponPerusahaan.clear();
                            title.clear();
                            keterangan.clear();
                            BlocProvider.of<AutoCompletePerusahaanBloc>(context)
                                .add(GetPerusahaan("", _character!.name, true, null));
                          });
                        },
                        groupValue: _character,
                        child: Text("Perorangan"),
                      ),
                    ),
                  ),
                ],
              ),
              SizedBox(height: 17),
              Text('Data Pelanggan',style: TextStyle(color: CustomStyle.color1,fontWeight: FontWeight.bold, fontSize: 15)),
              SizedBox(height: 17),

              BlocBuilder<AutoCompletePerusahaanBloc, AutoCompletePerusahaanState>(
                builder: (BuildContext context, AutoCompletePerusahaanState state){
                  if(state is GetPerusahaanSuccess) {
                    listDataPerusahaan = state.dropdownRespon;
                    // if(state.selectedValue != null){
                    //   setState(() {
                    //     dataPerusahaan = state.selectedValue;
                    //     pelangganBaru = false;
                    //     alamatPerusahaan.text = dataPerusahaan!.alamat!;
                    //     if(_character == SingingCharacter.Perusahaan) namaPICPerusahaan.text = dataPerusahaan!.picNama!;
                    //     emailPerusahaan.text = dataPerusahaan!.picEmail!;
                    //     noTeleponPerusahaan.text = dataPerusahaan!.picTelp!;
                    //     if(_character == SingingCharacter.Perusahaan) {
                    //       jenisPerusahaan = DataDropdown(id: dataPerusahaan!.jenisPerusahaan!.idJenisPerusahaanM, nama: dataPerusahaan!.jenisPerusahaan!.namaJenisPerusahaan, selected: true);
                    //       BlocProvider.of<DropdownJenisPerusahaanBloc>(context).add(SelectDataDropdownJenisPerusahaan(jenisPerusahaan!));
                    //     }
                    //     leadSource = DataDropdown(id: dataPerusahaan!.leadSource!.idLeadM, nama: dataPerusahaan!.leadSource!.namaLeadM, selected: true);
                    //     provinsi = JenisData(id: dataPerusahaan!.provinsi!.idProvinsi.toString(), nama: dataPerusahaan!.provinsi!.namaProvinsi);
                    //     BlocProvider.of<DropdownProvinsiBloc>(context)
                    //         .add(SelectDataDropdownProvinsi(provinsi!));
                    //     kabkota = JenisData(id: dataPerusahaan!.kota!.idKota.toString(), nama: dataPerusahaan!.kota!.namaKota);
                    //     BlocProvider.of<DropdownKabupatenBloc>(context)
                    //         .add(SelectDataDropdownKabupaten(kabkota!));
                    //     widget.dataCallback!(DataPerusahaan(
                    //         idPelanggan: dataPerusahaan!.idPelanggan,
                    //         namaPerusahaan: dataPerusahaan!.namaPerusahaan,
                    //         jenisPerusahaan: dataPerusahaan!.jenisPerusahaan,
                    //         leadSource: dataPerusahaan!.leadSource,
                    //         alamat: dataPerusahaan!.alamat,
                    //         provinsi: dataPerusahaan!.provinsi,
                    //         kota: dataPerusahaan!.kota,
                    //         picNama: dataPerusahaan!.picNama,
                    //         picEmail: dataPerusahaan!.picEmail,
                    //         picTelp: dataPerusahaan!.picTelp,
                    //         pelangganBaru: pelangganBaru,
                    //         title: title.text,
                    //         keterangan: keterangan.text
                    //     ));
                    //   });
                    // }
                  }

                  return Container(
                    height: 55,
                    child: InputDecorator(
                      decoration: InputDecoration(
                        label: Row(
                          children: [
                            Text("Nama Pelanggan"),
                            SizedBox(width: 7),
                            Text("*", style: TextStyle(color: Colors.red),),
                          ],
                        ),
                        contentPadding: EdgeInsets.only(bottom: 7),
                        enabledBorder: InputBorder.none
                        // enabledBorder: UnderlineInputBorder(borderSide: BorderSide(color: CustomStyle.colorLineFormDropdown)),
                      ),
                      child: Autocomplete<DataPerusahaan>(
                        displayStringForOption: (option) => option.namaPerusahaan!,
                        optionsBuilder: (TextEditingValue tectEditingValue){
                          if(dataPerusahaan == null){
                            pelangganBaru = true;
                            namaPerusahaan.text = tectEditingValue.text;
                            widget.dataCallback!(DataPerusahaan(
                                idSalesBawahan: dataPegawai==null?null:dataPegawai!.id,
                                idPelanggan: dataPerusahaan==null?null:dataPerusahaan!.idPelanggan,
                                namaPerusahaan: namaPerusahaan.text,
                                jenisPerusahaan: jenisPerusahaan == null ? null : JenisPerusahaan(
                                    idJenisPerusahaanM: jenisPerusahaan!.id,
                                    namaJenisPerusahaan: jenisPerusahaan!.nama
                                ),
                                leadSource: leadSource == null ? null : LeadSource(
                                    idLeadM: leadSource!.id,
                                    namaLeadM: leadSource!.nama
                                ),
                                alamat: alamatPerusahaan.text,
                                provinsi: provinsi == null ? null : Provinsi(
                                    idProvinsi: int.parse(provinsi!.id!),
                                    namaProvinsi: provinsi!.nama
                                ),
                                kota: kabkota == null ? null : Kota(
                                    idKota: int.parse(kabkota!.id!),
                                    namaKota: kabkota!.nama
                                ),
                                kecamatan: kecamatan == null ? null : Kecamatan(
                                    idKecamatan: int.parse(kecamatan!.id!),
                                    namaKecamatan: kecamatan!.nama
                                ),
                                kelurahan: kelurahan == null ? null : Kelurahan(
                                    idKelurahan: int.parse(kelurahan!.id!),
                                    namaKelurahan: kelurahan!.nama
                                ),
                                picNama: namaPICPerusahaan.text,
                                picEmail: emailPerusahaan.text,
                                picTelp: noTeleponPerusahaan.text,
                                title: title.text,
                                keterangan: keterangan.text,
                                pelangganBaru: pelangganBaru,
                                kategoriPelanggan: _character!.name
                            ));
                          }else{
                            if(tectEditingValue.text != dataPerusahaan!.namaPerusahaan){
                              // return Iterable<DataPerusahaan>.empty();
                              pelangganBaru = true;
                              namaPerusahaan.text = tectEditingValue.text;
                              widget.dataCallback!(DataPerusahaan(
                                  idSalesBawahan: dataPegawai==null?null:dataPegawai!.id,
                                  namaPerusahaan: namaPerusahaan.text,
                                  jenisPerusahaan: jenisPerusahaan == null ? null : JenisPerusahaan(
                                      idJenisPerusahaanM: jenisPerusahaan!.id,
                                      namaJenisPerusahaan: jenisPerusahaan!.nama
                                  ),
                                  leadSource: leadSource == null ? null : LeadSource(
                                      idLeadM: leadSource!.id,
                                      namaLeadM: leadSource!.nama
                                  ),
                                  alamat: alamatPerusahaan.text,
                                  provinsi: provinsi == null ? null : Provinsi(
                                      idProvinsi: int.parse(provinsi!.id!),
                                      namaProvinsi: provinsi!.nama
                                  ),
                                  kota: kabkota == null ? null : Kota(
                                      idKota: int.parse(kabkota!.id!),
                                      namaKota: kabkota!.nama
                                  ),
                                  kecamatan: kecamatan == null ? null : Kecamatan(
                                      idKecamatan: int.parse(kecamatan!.id!),
                                      namaKecamatan: kecamatan!.nama
                                  ),
                                  kelurahan: kelurahan == null ? null : Kelurahan(
                                      idKelurahan: int.parse(kelurahan!.id!),
                                      namaKelurahan: kelurahan!.nama
                                  ),
                                  picNama: namaPICPerusahaan.text,
                                  picEmail: emailPerusahaan.text,
                                  picTelp: noTeleponPerusahaan.text,
                                  title: title.text,
                                  keterangan: keterangan.text,
                                  pelangganBaru: pelangganBaru,
                                  kategoriPelanggan: _character!.name
                              ));
                            }
                          }

                          if(listDataPerusahaan != null){
                            return listDataPerusahaan!.data!.where((DataPerusahaan option){
                              return option.namaPerusahaan!.toLowerCase().contains(tectEditingValue.text.toLowerCase());
                            });
                          }else{
                            return Iterable<DataPerusahaan>.empty();
                          }
                        },
                        onSelected: (DataPerusahaan val){
                          setState(() {
                            dataPerusahaan = val;
                            pelangganBaru = false;
                            namaPerusahaan.text = dataPerusahaan!.namaPerusahaan!;
                            // if(_character == SingingCharacter.Perusahaan) {
                              jenisPerusahaan = DataDropdown(id: dataPerusahaan!.jenisPerusahaan!.idJenisPerusahaanM, nama: dataPerusahaan!.jenisPerusahaan!.namaJenisPerusahaan, selected: true);
                              BlocProvider.of<DropdownJenisPerusahaanBloc>(context).add(SelectDataDropdownJenisPerusahaan(jenisPerusahaan!));
                            // }
                            leadSource = DataDropdown(id: dataPerusahaan!.leadSource!.idLeadM, nama: dataPerusahaan!.leadSource!.namaLeadM, selected: true);
                            alamatPerusahaan.text = dataPerusahaan!.alamat!;
                            provinsi = JenisData(id: dataPerusahaan!.provinsi!.idProvinsi.toString(), nama: dataPerusahaan!.provinsi!.namaProvinsi);
                            BlocProvider.of<DropdownProvinsiBloc>(context)
                                .add(SelectSetValueDataDropdownProvinsi(provinsi!));
                            kabkota = JenisData(id: dataPerusahaan!.kota!.idKota.toString(), nama: dataPerusahaan!.kota!.namaKota);

                            BlocProvider.of<DropdownKabupatenBloc>(context).add(SetValueProvinsi(provinsi!.id!, kabkota));
                            if(dataPerusahaan!.kecamatan!.namaKecamatan != null){
                              kecamatan = JenisData(id: dataPerusahaan!.kecamatan!.idKecamatan.toString(), nama: dataPerusahaan!.kecamatan!.namaKecamatan);
                            }else{
                              kecamatan = null;
                            }
                            BlocProvider.of<DropdownKecamatanBloc>(context).add(SetValueKabupaten(kabkota!.id!, kecamatan));
                            if(dataPerusahaan!.kelurahan!.namaKelurahan != null){
                              kelurahan = JenisData(id: dataPerusahaan!.kelurahan!.idKelurahan.toString(), nama: dataPerusahaan!.kelurahan!.namaKelurahan);
                            }else{
                              kelurahan = null;
                            }

                            if(kecamatan != null){
                              BlocProvider.of<DropdownKelurahanBloc>(context).add(SetKecamatan(kecamatan!.id!, kelurahan));
                            }
                            if(_character == SingingCharacter.Perusahaan) namaPICPerusahaan.text = dataPerusahaan!.picNama!;
                            emailPerusahaan.text = dataPerusahaan!.picEmail!;
                            noTeleponPerusahaan.text = dataPerusahaan!.picTelp!;
                            widget.dataCallback!(DataPerusahaan(
                                idSalesBawahan: dataPegawai==null?null:dataPegawai!.id,
                                idPelanggan: dataPerusahaan!.idPelanggan,
                                namaPerusahaan: dataPerusahaan!.namaPerusahaan,
                                jenisPerusahaan: dataPerusahaan!.jenisPerusahaan,
                                leadSource: dataPerusahaan!.leadSource,
                                alamat: dataPerusahaan!.alamat,
                                provinsi: dataPerusahaan!.provinsi,
                                kota: dataPerusahaan!.kota,
                                kecamatan: dataPerusahaan!.kecamatan,
                                kelurahan: dataPerusahaan!.kelurahan,
                                picNama: dataPerusahaan!.picNama,
                                picEmail: dataPerusahaan!.picEmail,
                                picTelp: dataPerusahaan!.picTelp,
                                pelangganBaru: pelangganBaru,
                                title: title.text,
                                keterangan: keterangan.text,
                                kategoriPelanggan: _character!.name
                            ));
                          });
                        },
                      ),
                    ),
                  );
                },
                // child:


                // AutoCompletePerusahaan(
                //     dataCallback: (pelanggan, cust){
                //       print("object pelanggan : $provinsi");
                //       print("object cust : $kabkota");
                //       setState(() {
                //         pelangganBaru = cust!;
                //         dataPerusahaan = DataPerusahaan(
                //           title: title.text,
                //           keterangan: keterangan.text,
                //           namaPerusahaan: pelanggan,
                //           jenisPerusahaan: jenisPerusahaan == null ? null : JenisPerusahaan(
                //               idJenisPerusahaanM: jenisPerusahaan!.id,
                //               namaJenisPerusahaan: jenisPerusahaan!.nama
                //           ),
                //           leadSource: leadSource == null ? null : LeadSource(
                //               idLeadM: leadSource!.id,
                //               namaLeadM: leadSource!.nama
                //           ),
                //           // jenisPerusahaan: JenisPerusahaan(idJenisPerusahaanM: jenisPerusahaan!.id, namaJenisPerusahaan: jenisPerusahaan!.nama),
                //           // leadSource: LeadSource(idLeadM: leadSource!.id, namaLeadM: leadSource!.nama),
                //           alamat: alamatPerusahaan.text,
                //           provinsi: provinsi == null ? null : Provinsi(
                //               idProvinsi: int.parse(provinsi!.id!),
                //               namaProvinsi: provinsi!.nama
                //           ),
                //           kota: kabkota == null ? null : Kota(
                //               idKota: int.parse(kabkota!.id!),
                //               namaKota: kabkota!.nama
                //           ),
                //           // provinsi: Provinsi(idProvinsi: int.parse(provinsi!.id!), namaProvinsi: provinsi!.nama),
                //           // kota: Kota(idKota: int.parse(kabkota!.id!), namaKota: kabkota!.nama),
                //           picNama: namaPICPerusahaan.text,
                //           picEmail: emailPerusahaan.text,
                //           picTelp: noTeleponPerusahaan.text,
                //           pelangganBaru: pelangganBaru,
                //         );
                //         widget.dataCallback!(DataPerusahaan(
                //             idPelanggan: dataPerusahaan!.idPelanggan,
                //             namaPerusahaan: pelanggan,
                //             jenisPerusahaan: dataPerusahaan!.jenisPerusahaan,//JenisPerusahaan(idJenisPerusahaanM: jenisPerusahaan!.id, namaJenisPerusahaan: jenisPerusahaan!.nama),
                //             leadSource: dataPerusahaan!.leadSource,
                //             alamat: dataPerusahaan!.alamat,
                //             provinsi: dataPerusahaan!.provinsi,
                //             kota: dataPerusahaan!.kota,
                //             picNama: dataPerusahaan!.picNama,
                //             picEmail: dataPerusahaan!.picEmail,
                //             picTelp: dataPerusahaan!.picTelp,
                //             pelangganBaru: pelangganBaru,
                //             title: title.text,
                //             keterangan: keterangan.text
                //         ));
                //       });
                //
                //       print("object po : ${dataPerusahaan!.namaPerusahaan}");
                //     },
                //     fontSize:CustomStyle.fontSizeSmall,
                //     radius: 14,
                //     formHeight: 34,
                //     title: "Nama ${_character!.name}",
                //     prefixIcon: Icon(Icons.search, size: 20)
                // ),
              ),
              // _character == SingingCharacter.Perusahaan
              //   ?
              BlocListener<DropdownJenisPerusahaanBloc, DropdownJenisPerusahaanState>(
                    listener: (BuildContext context, DropdownJenisPerusahaanState state) {
                      if (state is DropdownJenisPerusahaanSuccessState && state.selectedValue != null) {
                        jenisPerusahaan = state.selectedValue;
                        widget.dataCallback!(DataPerusahaan(
                            idSalesBawahan: dataPegawai==null?null:dataPegawai!.id,
                            idPelanggan: dataPerusahaan==null?null:dataPerusahaan!.idPelanggan,
                            namaPerusahaan: namaPerusahaan.text,
                            jenisPerusahaan: jenisPerusahaan == null ? null : JenisPerusahaan(
                                idJenisPerusahaanM: jenisPerusahaan!.id,
                                namaJenisPerusahaan: jenisPerusahaan!.nama
                            ),
                            leadSource: leadSource == null ? null : LeadSource(
                                idLeadM: leadSource!.id,
                                namaLeadM: leadSource!.nama
                            ),
                            alamat: alamatPerusahaan.text,
                            provinsi: provinsi == null ? null : Provinsi(
                                idProvinsi: int.parse(provinsi!.id!),
                                namaProvinsi: provinsi!.nama
                            ),
                            kota: kabkota == null ? null : Kota(
                                idKota: int.parse(kabkota!.id!),
                                namaKota: kabkota!.nama
                            ),
                            kecamatan: kecamatan == null ? null : Kecamatan(
                                idKecamatan: int.parse(kecamatan!.id!),
                                namaKecamatan: kecamatan!.nama
                            ),
                            kelurahan: kelurahan == null ? null : Kelurahan(
                                idKelurahan: int.parse(kelurahan!.id!),
                                namaKelurahan: kelurahan!.nama
                            ),
                            picNama: namaPICPerusahaan.text,
                            picEmail: emailPerusahaan.text,
                            picTelp: noTeleponPerusahaan.text,
                            pelangganBaru: pelangganBaru,
                            title: title.text,
                            keterangan: keterangan.text,
                            kategoriPelanggan: _character!.name
                        ));
                      }
                    },
                    child: DropdownJenisPerusahaan(
                      'Jenis ${_character!.name}',
                      _character!.name,
                      initialData: jenisPerusahaan == null ? null : jenisPerusahaan!.nama,
                      color: Colors.grey[600],
                      marginHorizontal: 3,
                    ),
                  ),
                // : Container(),
              _character == SingingCharacter.Perorangan ? SizedBox(height: 7) : Container(),
              BlocListener<DropdownLeadMasterBloc, DropdownLeadMasterState>(
                    listener: (BuildContext context, DropdownLeadMasterState state) {
                      if (state is DropdownLeadMasterSuccessState && state.selectedValue != null) {
                        leadSource = state.selectedValue;
                        widget.dataCallback!(DataPerusahaan(
                            idSalesBawahan: dataPegawai==null?null:dataPegawai!.id,
                            idPelanggan: dataPerusahaan==null?null:dataPerusahaan!.idPelanggan,
                            namaPerusahaan: namaPerusahaan.text,
                            jenisPerusahaan: jenisPerusahaan == null ? null : JenisPerusahaan(
                                idJenisPerusahaanM: jenisPerusahaan!.id,
                                namaJenisPerusahaan: jenisPerusahaan!.nama
                            ),
                            leadSource: leadSource == null ? null : LeadSource(
                                idLeadM: leadSource!.id,
                                namaLeadM: leadSource!.nama
                            ),
                            alamat: alamatPerusahaan.text,
                            provinsi: provinsi == null ? null : Provinsi(
                                idProvinsi: int.parse(provinsi!.id!),
                                namaProvinsi: provinsi!.nama
                            ),
                            kota: kabkota == null ? null : Kota(
                                idKota: int.parse(kabkota!.id!),
                                namaKota: kabkota!.nama
                            ),
                            kecamatan: kecamatan == null ? null : Kecamatan(
                                idKecamatan: int.parse(kecamatan!.id!),
                                namaKecamatan: kecamatan!.nama
                            ),
                            kelurahan: kelurahan == null ? null : Kelurahan(
                                idKelurahan: int.parse(kelurahan!.id!),
                                namaKelurahan: kelurahan!.nama
                            ),
                            picNama: namaPICPerusahaan.text,
                            picEmail: emailPerusahaan.text,
                            picTelp: noTeleponPerusahaan.text,
                            pelangganBaru: pelangganBaru,
                            title: title.text,
                            keterangan: keterangan.text,
                            kategoriPelanggan: _character!.name
                        ));
                      }
                    },
                    child: DropdownLeadMaster(
                      'Lead Source',
                      initialData: leadSource == null ? null : leadSource!.nama,
                      color: Colors.grey[600],
                      marginHorizontal: 3,
                    ),
                  ),
              SizedBox(height: 13),
              Text('Alamat Pelanggan',style: TextStyle(color: CustomStyle.color1,fontWeight: FontWeight.bold, fontSize: 15)),
              SizedBox(height: 17),
              TemplateTextFormAkun(
                    adaValidasi: true,
                    controller: alamatPerusahaan,
                    color: Colors.black,
                    marginHorizontal: 0,
                    fontSize: 13,
                    titleText: 'Alamat',
                    radius: CustomStyle.formRadius,
                    onChange: (val){
                      widget.dataCallback!(DataPerusahaan(
                          idSalesBawahan: dataPegawai==null?null:dataPegawai!.id,
                          idPelanggan: dataPerusahaan==null?null:dataPerusahaan!.idPelanggan,
                          namaPerusahaan: namaPerusahaan.text,
                          jenisPerusahaan: jenisPerusahaan == null ? null : JenisPerusahaan(
                              idJenisPerusahaanM: jenisPerusahaan!.id,
                              namaJenisPerusahaan: jenisPerusahaan!.nama
                          ),
                          leadSource: leadSource == null ? null : LeadSource(
                              idLeadM: leadSource!.id,
                              namaLeadM: leadSource!.nama
                          ),
                          alamat: alamatPerusahaan.text,
                          provinsi: provinsi == null ? null : Provinsi(
                              idProvinsi: int.parse(provinsi!.id!),
                              namaProvinsi: provinsi!.nama
                          ),
                          kota: kabkota == null ? null : Kota(
                              idKota: int.parse(kabkota!.id!),
                              namaKota: kabkota!.nama
                          ),
                          kecamatan: kecamatan == null ? null : Kecamatan(
                              idKecamatan: int.parse(kecamatan!.id!),
                              namaKecamatan: kecamatan!.nama
                          ),
                          kelurahan: kelurahan == null ? null : Kelurahan(
                              idKelurahan: int.parse(kelurahan!.id!),
                              namaKelurahan: kelurahan!.nama
                          ),
                          picNama: namaPICPerusahaan.text,
                          picEmail: emailPerusahaan.text,
                          picTelp: noTeleponPerusahaan.text,
                          pelangganBaru: pelangganBaru,
                          title: title.text,
                          keterangan: keterangan.text,
                          kategoriPelanggan: _character!.name
                      ));
                    },
                  ),
              BlocListener<DropdownProvinsiBloc, DropdownProvinsiState>(
                    listener: (BuildContext context, DropdownProvinsiState state) {
                      if ((state is DropdownProvinsiSuccessState && state.selectedValue != null) || (state is DropdownProvinsiSetValueSuccessState && state.selectedValue != null)) {
                        if(state is DropdownProvinsiSuccessState){
                          provinsi = state.selectedValue;
                          kabkota = null;
                          kecamatan = null;
                          kelurahan = null;
                          BlocProvider.of<DropdownKabupatenBloc>(context).add(SetProvinsi(provinsi!.id!, kabkota));
                          BlocProvider.of<DropdownKecamatanBloc>(context).add(ClearDataDropdownKecamatan());
                          BlocProvider.of<DropdownKelurahanBloc>(context).add(ClearDataDropdownKelurahan());
                        }else if (state is DropdownProvinsiSetValueSuccessState){
                          provinsi = state.selectedValue;
                        }
                        widget.dataCallback!(DataPerusahaan(
                            idSalesBawahan: dataPegawai==null?null:dataPegawai!.id,
                            idPelanggan: dataPerusahaan==null?null:dataPerusahaan!.idPelanggan,
                            namaPerusahaan: namaPerusahaan.text,
                            jenisPerusahaan: jenisPerusahaan == null ? null : JenisPerusahaan(
                                idJenisPerusahaanM: jenisPerusahaan!.id,
                                namaJenisPerusahaan: jenisPerusahaan!.nama
                            ),
                            leadSource: leadSource == null ? null : LeadSource(
                                idLeadM: leadSource!.id,
                                namaLeadM: leadSource!.nama
                            ),
                            alamat: alamatPerusahaan.text,
                            provinsi: provinsi == null ? null : Provinsi(
                                idProvinsi: int.parse(provinsi!.id!),
                                namaProvinsi: provinsi!.nama
                            ),
                            kota: kabkota == null ? null : Kota(
                                idKota: int.parse(kabkota!.id!),
                                namaKota: kabkota!.nama
                            ),
                            kecamatan: kecamatan == null ? null : Kecamatan(
                                idKecamatan: int.parse(kecamatan!.id!),
                                namaKecamatan: kecamatan!.nama
                            ),
                            kelurahan: kelurahan == null ? null : Kelurahan(
                                idKelurahan: int.parse(kelurahan!.id!),
                                namaKelurahan: kelurahan!.nama
                            ),
                            picNama: namaPICPerusahaan.text,
                            picEmail: emailPerusahaan.text,
                            picTelp: noTeleponPerusahaan.text,
                            pelangganBaru: pelangganBaru,
                            title: title.text,
                            keterangan: keterangan.text,
                            kategoriPelanggan: _character!.name
                        ));
                      }
                    },
                    child: DropdownJenisProvinsi(
                      'Provinsi',
                      initialData: provinsi == null ? null : provinsi!.nama,
                      color: Colors.grey[600],
                      marginHorizontal: 3,
                      marginTop: 0,
                    ),
                  ),
              BlocListener<DropdownKabupatenBloc, DropdownKabupatenState>(
                    listener: (BuildContext context, DropdownKabupatenState state) {
                      if ((state is DropdownKabupatenSuccessState && state.selectedValue != null) || (state is DropdownKabupatenSetValueSuccessState && state.selectedValue != null)) {
                        if(state is DropdownKabupatenSuccessState){
                          kabkota = state.selectedValue;
                          kecamatan = null;
                          kelurahan = null;
                          BlocProvider.of<DropdownKecamatanBloc>(context).add(SetKabupaten(kabkota!.id!, null));
                          BlocProvider.of<DropdownKelurahanBloc>(context).add(ClearDataDropdownKelurahan());
                        }else if (state is DropdownKabupatenSetValueSuccessState){
                          kabkota = state.selectedValue;
                        }

                        widget.dataCallback!(DataPerusahaan(
                            idSalesBawahan: dataPegawai==null?null:dataPegawai!.id,
                            idPelanggan: dataPerusahaan==null?null:dataPerusahaan!.idPelanggan,
                            namaPerusahaan: namaPerusahaan.text,
                            jenisPerusahaan: jenisPerusahaan == null ? null : JenisPerusahaan(
                                idJenisPerusahaanM: jenisPerusahaan!.id,
                                namaJenisPerusahaan: jenisPerusahaan!.nama
                            ),
                            leadSource: leadSource == null ? null : LeadSource(
                                idLeadM: leadSource!.id,
                                namaLeadM: leadSource!.nama
                            ),
                            alamat: alamatPerusahaan.text,
                            provinsi: provinsi == null ? null : Provinsi(
                                idProvinsi: int.parse(provinsi!.id!),
                                namaProvinsi: provinsi!.nama
                            ),
                            kota: kabkota == null ? null : Kota(
                                idKota: int.parse(kabkota!.id!),
                                namaKota: kabkota!.nama
                            ),
                            kecamatan: kecamatan == null ? null : Kecamatan(
                                idKecamatan: int.parse(kecamatan!.id!),
                                namaKecamatan: kecamatan!.nama
                            ),
                            kelurahan: kelurahan == null ? null : Kelurahan(
                                idKelurahan: int.parse(kelurahan!.id!),
                                namaKelurahan: kelurahan!.nama
                            ),
                            picNama: namaPICPerusahaan.text,
                            picEmail: emailPerusahaan.text,
                            picTelp: noTeleponPerusahaan.text,
                            pelangganBaru: pelangganBaru,
                            title: title.text,
                            keterangan: keterangan.text,
                            kategoriPelanggan: _character!.name
                        ));
                      }
                    },
                    child: DropdownJenisKabupaten(
                      'Kota',
                      initialData: kabkota == null ? null : kabkota,
                      validasi: true,
                      color: Colors.grey[600],
                      marginHorizontal: 3,
                      marginTop: 0,
                      idProv: provinsi == null ? null : provinsi!.id,
                    ),
                  ),
              BlocListener<DropdownKecamatanBloc, DropdownKecamatanState>(
                listener: (BuildContext context, DropdownKecamatanState state) {
                  if ((state is DropdownKecamatanSuccessState && state.selectedValue != null) || (state is DropdownKecamatanSetValueSuccessState && state.selectedValue != null)) {
                    if(state is DropdownKecamatanSuccessState){
                      kecamatan = state.selectedValue;
                      kelurahan = null;
                      BlocProvider.of<DropdownKelurahanBloc>(context).add(SetKecamatan(kecamatan!.id!, kelurahan));
                    }else if (state is DropdownKecamatanSetValueSuccessState){
                      kecamatan = state.selectedValue;
                    }

                    widget.dataCallback!(DataPerusahaan(
                        idSalesBawahan: dataPegawai==null?null:dataPegawai!.id,
                        idPelanggan: dataPerusahaan==null?null:dataPerusahaan!.idPelanggan,
                        namaPerusahaan: namaPerusahaan.text,
                        jenisPerusahaan: jenisPerusahaan == null ? null : JenisPerusahaan(
                            idJenisPerusahaanM: jenisPerusahaan!.id,
                            namaJenisPerusahaan: jenisPerusahaan!.nama
                        ),
                        leadSource: leadSource == null ? null : LeadSource(
                            idLeadM: leadSource!.id,
                            namaLeadM: leadSource!.nama
                        ),
                        alamat: alamatPerusahaan.text,
                        provinsi: provinsi == null ? null : Provinsi(
                            idProvinsi: int.parse(provinsi!.id!),
                            namaProvinsi: provinsi!.nama
                        ),
                        kota: kabkota == null ? null : Kota(
                            idKota: int.parse(kabkota!.id!),
                            namaKota: kabkota!.nama
                        ),
                        kecamatan: kecamatan == null ? null : Kecamatan(
                            idKecamatan: int.parse(kecamatan!.id!),
                            namaKecamatan: kecamatan!.nama
                        ),
                        kelurahan: kelurahan == null ? null : Kelurahan(
                            idKelurahan: int.parse(kelurahan!.id!),
                            namaKelurahan: kelurahan!.nama
                        ),
                        picNama: namaPICPerusahaan.text,
                        picEmail: emailPerusahaan.text,
                        picTelp: noTeleponPerusahaan.text,
                        pelangganBaru: pelangganBaru,
                        title: title.text,
                        keterangan: keterangan.text,
                        kategoriPelanggan: _character!.name
                    ));
                  }
                },
                child: DropdownJenisKecamatan(
                  'Kecamatan',
                  initialData: kecamatan == null ? null : kecamatan,
                  validasi: false,
                  color: Colors.grey[600],
                  marginHorizontal: 3,
                  marginTop: 0,
                  idKab: kabkota == null ? null : kabkota!.id,
                ),
              ),
              BlocListener<DropdownKelurahanBloc, DropdownKelurahanState>(
                listener: (BuildContext context, DropdownKelurahanState state) {
                  if ((state is DropdownKelurahanSuccessState && state.selectedValue != null) || (state is DropdownKelurahanSetValueSuccessState && state.selectedValue != null)) {
                    if(state is DropdownKelurahanSuccessState){
                      kelurahan = state.selectedValue;
                    }else if (state is DropdownKelurahanSetValueSuccessState){
                      kelurahan = state.selectedValue;
                    }

                    widget.dataCallback!(DataPerusahaan(
                        idSalesBawahan: dataPegawai==null?null:dataPegawai!.id,
                        idPelanggan: dataPerusahaan==null?null:dataPerusahaan!.idPelanggan,
                        namaPerusahaan: namaPerusahaan.text,
                        jenisPerusahaan: jenisPerusahaan == null ? null : JenisPerusahaan(
                            idJenisPerusahaanM: jenisPerusahaan!.id,
                            namaJenisPerusahaan: jenisPerusahaan!.nama
                        ),
                        leadSource: leadSource == null ? null : LeadSource(
                            idLeadM: leadSource!.id,
                            namaLeadM: leadSource!.nama
                        ),
                        alamat: alamatPerusahaan.text,
                        provinsi: provinsi == null ? null : Provinsi(
                            idProvinsi: int.parse(provinsi!.id!),
                            namaProvinsi: provinsi!.nama
                        ),
                        kota: kabkota == null ? null : Kota(
                            idKota: int.parse(kabkota!.id!),
                            namaKota: kabkota!.nama
                        ),
                        kecamatan: kecamatan == null ? null : Kecamatan(
                            idKecamatan: int.parse(kecamatan!.id!),
                            namaKecamatan: kecamatan!.nama
                        ),
                        kelurahan: kelurahan == null ? null : Kelurahan(
                            idKelurahan: int.parse(kelurahan!.id!),
                            namaKelurahan: kelurahan!.nama
                        ),
                        picNama: namaPICPerusahaan.text,
                        picEmail: emailPerusahaan.text,
                        picTelp: noTeleponPerusahaan.text,
                        pelangganBaru: pelangganBaru,
                        title: title.text,
                        keterangan: keterangan.text,
                        kategoriPelanggan: _character!.name
                    ));
                  }
                },
                child: DropdownJenisKelurahan(
                  'Kelurahan',
                  initialData: kelurahan == null ? null : kelurahan!.nama == null ? null : kelurahan,
                  validasi: false,
                  color: Colors.grey[600],
                  marginHorizontal: 3,
                  marginTop: 0,
                  idKac: kecamatan == null ? null : kecamatan!.id,
                ),
              ),
              SizedBox(height: _character == SingingCharacter.Perusahaan ? 13 : 0),
              _character == SingingCharacter.Perusahaan
                ? Text('Data PIC',style: TextStyle(color: CustomStyle.color1,fontWeight: FontWeight.bold, fontSize: 15))
                : Container(),
              SizedBox(height: _character == SingingCharacter.Perusahaan ? 17 : 0),
              _character == SingingCharacter.Perusahaan
                ? TemplateTextFormAkun(
                    adaValidasi: true,
                    controller: namaPICPerusahaan,
                    color: Colors.black,
                    marginHorizontal: 0,
                    fontSize: 13,
                    titleText: 'Nama PIC',
                    radius: CustomStyle.formRadius,
                    onChange: (val){
                      widget.dataCallback!(DataPerusahaan(
                          idSalesBawahan: dataPegawai==null?null:dataPegawai!.id,
                          idPelanggan: dataPerusahaan==null?null:dataPerusahaan!.idPelanggan,
                          namaPerusahaan: namaPerusahaan.text,
                          jenisPerusahaan: jenisPerusahaan == null ? null : JenisPerusahaan(
                              idJenisPerusahaanM: jenisPerusahaan!.id,
                              namaJenisPerusahaan: jenisPerusahaan!.nama
                          ),
                          leadSource: leadSource == null ? null : LeadSource(
                              idLeadM: leadSource!.id,
                              namaLeadM: leadSource!.nama
                          ),
                          alamat: alamatPerusahaan.text,
                          provinsi: provinsi == null ? null : Provinsi(
                              idProvinsi: int.parse(provinsi!.id!),
                              namaProvinsi: provinsi!.nama
                          ),
                          kota: kabkota == null ? null : Kota(
                              idKota: int.parse(kabkota!.id!),
                              namaKota: kabkota!.nama
                          ),
                          kecamatan: kecamatan == null ? null : Kecamatan(
                              idKecamatan: int.parse(kecamatan!.id!),
                              namaKecamatan: kecamatan!.nama
                          ),
                          kelurahan: kelurahan == null ? null : Kelurahan(
                              idKelurahan: int.parse(kelurahan!.id!),
                              namaKelurahan: kelurahan!.nama
                          ),
                          picNama: namaPICPerusahaan.text,
                          picEmail: emailPerusahaan.text,
                          picTelp: noTeleponPerusahaan.text,
                          pelangganBaru: pelangganBaru,
                          title: title.text,
                          keterangan: keterangan.text,
                          kategoriPelanggan: _character!.name
                      ));
                    },
                  )
                : Container(),
              TemplateTextFormAkun(
                    adaValidasi: false,
                    controller: emailPerusahaan,
                    color: Colors.black,
                    marginHorizontal: 0,
                    fontSize: 13,
                    titleText: 'Email',
                    radius: CustomStyle.formRadius,
                    onChange: (val){
                      widget.dataCallback!(DataPerusahaan(
                          idSalesBawahan: dataPegawai==null?null:dataPegawai!.id,
                          idPelanggan: dataPerusahaan==null?null:dataPerusahaan!.idPelanggan,
                          namaPerusahaan: namaPerusahaan.text,
                          jenisPerusahaan: jenisPerusahaan == null ? null : JenisPerusahaan(
                              idJenisPerusahaanM: jenisPerusahaan!.id,
                              namaJenisPerusahaan: jenisPerusahaan!.nama
                          ),
                          leadSource: leadSource == null ? null : LeadSource(
                              idLeadM: leadSource!.id,
                              namaLeadM: leadSource!.nama
                          ),
                          alamat: alamatPerusahaan.text,
                          provinsi: provinsi == null ? null : Provinsi(
                              idProvinsi: int.parse(provinsi!.id!),
                              namaProvinsi: provinsi!.nama
                          ),
                          kota: kabkota == null ? null : Kota(
                              idKota: int.parse(kabkota!.id!),
                              namaKota: kabkota!.nama
                          ),
                          kecamatan: kecamatan == null ? null : Kecamatan(
                              idKecamatan: int.parse(kecamatan!.id!),
                              namaKecamatan: kecamatan!.nama
                          ),
                          kelurahan: kelurahan == null ? null : Kelurahan(
                              idKelurahan: int.parse(kelurahan!.id!),
                              namaKelurahan: kelurahan!.nama
                          ),
                          picNama: namaPICPerusahaan.text,
                          picEmail: emailPerusahaan.text,
                          picTelp: noTeleponPerusahaan.text,
                          pelangganBaru: pelangganBaru,
                          title: title.text,
                          keterangan: keterangan.text,
                          kategoriPelanggan: _character!.name
                      ));
                    },
                  ),
              TemplateTextFormAkun(
                    adaValidasi: true,
                    controller: noTeleponPerusahaan,
                    color: Colors.black,
                    marginHorizontal: 0,
                    keyboardNumber: true,
                    fontSize: 13,
                    titleText: 'No. Telepon',
                    radius: CustomStyle.formRadius,
                    onChange: (val){
                      widget.dataCallback!(DataPerusahaan(
                          idSalesBawahan: dataPegawai==null?null:dataPegawai!.id,
                          idPelanggan: dataPerusahaan==null?null:dataPerusahaan!.idPelanggan,
                          namaPerusahaan: namaPerusahaan.text,
                          jenisPerusahaan: jenisPerusahaan == null ? null : JenisPerusahaan(
                              idJenisPerusahaanM: jenisPerusahaan!.id,
                              namaJenisPerusahaan: jenisPerusahaan!.nama
                          ),
                          leadSource: leadSource == null ? null : LeadSource(
                              idLeadM: leadSource!.id,
                              namaLeadM: leadSource!.nama
                          ),
                          alamat: alamatPerusahaan.text,
                          provinsi: provinsi == null ? null : Provinsi(
                              idProvinsi: int.parse(provinsi!.id!),
                              namaProvinsi: provinsi!.nama
                          ),
                          kota: kabkota == null ? null : Kota(
                              idKota: int.parse(kabkota!.id!),
                              namaKota: kabkota!.nama
                          ),
                          kecamatan: kecamatan == null ? null : Kecamatan(
                              idKecamatan: int.parse(kecamatan!.id!),
                              namaKecamatan: kecamatan!.nama
                          ),
                          kelurahan: kelurahan == null ? null : Kelurahan(
                              idKelurahan: int.parse(kelurahan!.id!),
                              namaKelurahan: kelurahan!.nama
                          ),
                          picNama: namaPICPerusahaan.text,
                          picEmail: emailPerusahaan.text,
                          picTelp: noTeleponPerusahaan.text,
                          pelangganBaru: pelangganBaru,
                          title: title.text,
                          keterangan: keterangan.text,
                          kategoriPelanggan: _character!.name
                      ));
                    },
                  ),
              TemplateTextFormAkun(
                adaValidasi: true,
                controller: title,
                color: Colors.black,
                marginHorizontal: 0,
                fontSize: 13,
                titleText: 'Title',
                radius: CustomStyle.formRadius,
                onChange: (val){
                  widget.dataCallback!(DataPerusahaan(
                      idSalesBawahan: dataPegawai==null?null:dataPegawai!.id,
                      idPelanggan: dataPerusahaan==null?null:dataPerusahaan!.idPelanggan,
                      namaPerusahaan: namaPerusahaan.text,
                      jenisPerusahaan: jenisPerusahaan == null ? null : JenisPerusahaan(
                          idJenisPerusahaanM: jenisPerusahaan!.id,
                          namaJenisPerusahaan: jenisPerusahaan!.nama
                      ),
                      leadSource: leadSource == null ? null : LeadSource(
                          idLeadM: leadSource!.id,
                          namaLeadM: leadSource!.nama
                      ),
                      alamat: alamatPerusahaan.text,
                      provinsi: provinsi == null ? null : Provinsi(
                          idProvinsi: int.parse(provinsi!.id!),
                          namaProvinsi: provinsi!.nama
                      ),
                      kota: kabkota == null ? null : Kota(
                          idKota: int.parse(kabkota!.id!),
                          namaKota: kabkota!.nama
                      ),
                      kecamatan: kecamatan == null ? null : Kecamatan(
                          idKecamatan: int.parse(kecamatan!.id!),
                          namaKecamatan: kecamatan!.nama
                      ),
                      kelurahan: kelurahan == null ? null : Kelurahan(
                          idKelurahan: int.parse(kelurahan!.id!),
                          namaKelurahan: kelurahan!.nama
                      ),
                      picNama: namaPICPerusahaan.text,
                      picEmail: emailPerusahaan.text,
                      picTelp: noTeleponPerusahaan.text,
                      title: title.text,
                      keterangan: keterangan.text,
                      pelangganBaru: pelangganBaru,
                      kategoriPelanggan: _character!.name
                  ));
                },
              ),
              TemplateTextFormAkun(
                adaValidasi: true,
                controller: keterangan,
                color: Colors.black,
                marginHorizontal: 0,
                fontSize: 13,
                titleText: 'Keterangan',
                radius: CustomStyle.formRadius,
                onChange: (val){
                  widget.dataCallback!(DataPerusahaan(
                      idSalesBawahan: dataPegawai==null?null:dataPegawai!.id,
                      idPelanggan: dataPerusahaan==null?null:dataPerusahaan!.idPelanggan,
                      namaPerusahaan: namaPerusahaan.text,
                      jenisPerusahaan: jenisPerusahaan == null ? null : JenisPerusahaan(
                          idJenisPerusahaanM: jenisPerusahaan!.id,
                          namaJenisPerusahaan: jenisPerusahaan!.nama
                      ),
                      leadSource: leadSource == null ? null : LeadSource(
                          idLeadM: leadSource!.id,
                          namaLeadM: leadSource!.nama
                      ),
                      alamat: alamatPerusahaan.text,
                      provinsi: provinsi == null ? null : Provinsi(
                          idProvinsi: int.parse(provinsi!.id!),
                          namaProvinsi: provinsi!.nama
                      ),
                      kota: kabkota == null ? null : Kota(
                          idKota: int.parse(kabkota!.id!),
                          namaKota: kabkota!.nama
                      ),
                      kecamatan: kecamatan == null ? null : Kecamatan(
                          idKecamatan: int.parse(kecamatan!.id!),
                          namaKecamatan: kecamatan!.nama
                      ),
                      kelurahan: kelurahan == null ? null : Kelurahan(
                          idKelurahan: int.parse(kelurahan!.id!),
                          namaKelurahan: kelurahan!.nama
                      ),
                      picNama: namaPICPerusahaan.text,
                      picEmail: emailPerusahaan.text,
                      picTelp: noTeleponPerusahaan.text,
                      title: title.text,
                      keterangan: keterangan.text,
                      pelangganBaru: pelangganBaru,
                      kategoriPelanggan: _character!.name
                  ));
                },
              ),
            ],
          ),
        ),
      ),
    );
  }
}

enum SingingCharacter { Perusahaan, Perorangan }
