import 'package:absenkuv3/Bloc/SalesActivity/PelangganBloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class KomponenDataPelanggan extends StatefulWidget {
  String idPelanggan;
  String idPipelineMain;
  KomponenDataPelanggan(this.idPelanggan, this.idPipelineMain);

  @override
  State<KomponenDataPelanggan> createState() => _KomponenDataPelangganState();
}

class _KomponenDataPelangganState extends State<KomponenDataPelanggan> {


  @override
  void initState() {
    super.initState();
    BlocProvider.of<PelangganBloc>(context).add(GetPelangganEvent(context, widget.idPelanggan, widget.idPipelineMain));
  }


  @override
  Widget build(BuildContext context) {
    return BlocBuilder<PelangganBloc, PelangganState>(
        builder: (context, statePelanggan) {
          if(statePelanggan is getPelangganSuccessState){
            return Container(
                margin: EdgeInsets.fromLTRB(27, 0, 27, 0),
                child: SingleChildScrollView(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Container(
                        margin: EdgeInsets.only(bottom: 15, left: 0, right: 0),
                        child: Row(
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          children: [
                            Expanded(
                              child: Column(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  Text(""),
                                  SizedBox(height: 3),
                                  Text(
                                      statePelanggan.dataPelanggan![0].namaPerusahaan!,
                                      style: TextStyle(color: Colors.black, fontWeight: FontWeight.bold, fontSize: 15)),
                                ],
                              ),
                            ),
                          ],
                        ),
                      ),
                      statePelanggan.dataPelanggan![0].jenisPerusahaan!.namaJenisPerusahaan == null ? Container() :
                      formSee("Jenis Perusahaan", statePelanggan.dataPelanggan![0].jenisPerusahaan!.namaJenisPerusahaan!),
                      formSee("Lead Source", statePelanggan.dataPelanggan![0].leadSource!.namaLeadM!),
                      formSee("Alamat", statePelanggan.dataPelanggan![0].alamat!),
                      formSee("Provinsi", statePelanggan.dataPelanggan![0].provinsi!.namaProvinsi!),
                      formSee("Kota", statePelanggan.dataPelanggan![0].kota!.namaKota!),
                      formSee("Kecamatan", statePelanggan.dataPelanggan![0].kecamatan!.namaKecamatan??'-'),
                      formSee("Kelurahan", statePelanggan.dataPelanggan![0].kelurahan!.namaKelurahan??'-'),
                      statePelanggan.dataPelanggan![0].jenisPerusahaan!.namaJenisPerusahaan == null ? Container() :
                      formSee("Nama PIC", statePelanggan.dataPelanggan![0].picNama!),
                      formSee("Email", statePelanggan.dataPelanggan![0].picEmail!),
                      formSee("No. Telepon", statePelanggan.dataPelanggan![0].picTelp!),
                      formSee("Title", statePelanggan.dataPelanggan![0].title!),
                      formSee("Keterangan", statePelanggan.dataPelanggan![0].keterangan!),
                    ],
                  ),
                ));
          }else{
            return Center(
              child: CircularProgressIndicator(strokeWidth: 8),
            );
          }

        }
    );
  }

  Widget formSee(String title, String data){
    return Container(
      margin: EdgeInsets.only(bottom: 15, left: 0, right: 15),
      child: Column(
        mainAxisAlignment: MainAxisAlignment.start,
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Text(
              title,
              style: TextStyle(color: Color(0xFF828282), fontSize: 13)),
          SizedBox(height: 3),
          Text(
              data.isEmpty?"-":data,
              style: TextStyle(color: Colors.black, fontWeight: FontWeight.w500, fontSize: 13)),
        ],
      ),
    );
  }
}
