import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/DataAktivitasSalesBloc.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mDataKanban.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/SalesActivity/Kanban/cardAktivitas.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class KomponenDataAktivitas extends StatefulWidget {
  String idPelanggan;
  String namaPelanggan;
  DataKanban? dataKanban;
  GlobalKey<ScaffoldState> _scaffoldKey;
  KomponenDataAktivitas(this.idPelanggan, this.namaPelanggan, this.dataKanban, this._scaffoldKey);

  @override
  State<KomponenDataAktivitas> createState() => _KomponenDataAktivitasState();
}

class _KomponenDataAktivitasState extends State<KomponenDataAktivitas> {
  ScrollController _scrollController = new ScrollController();
  // GlobalKey<ScaffoldState> _scaffoldKey = GlobalKey();

  @override
  void initState() {
    super.initState();
    BlocProvider.of<DataAktivitasSalesBloc>(context).add(getListDataAktivitasSalesEvent(context, widget.idPelanggan, widget.dataKanban!.idPipelineMain));
    _scrollController.addListener(()=>BlocProvider.of<DataAktivitasSalesBloc>(context).add(loadMoreEvent(context, widget._scaffoldKey, _scrollController)));
  }


  @override
  Widget build(BuildContext context) {
    return BlocBuilder<DataAktivitasSalesBloc, DataAktivitasSalesState>(
        builder: (context, state) {
          if(state is getListDataAktivitasSalesSuccessState || state is LoadMoreProgressState){
            return Stack(
              children: [
                state.data!.length > 0
                  ? ListView.builder(
                      itemCount: state.data!.length,
                      controller: _scrollController,
                      itemBuilder: (context, index){
                        return CardAktivitas(state.data![index]);
                      })

                  : Center(child: Image.asset(ValueImage.noData, height: 250)),
                state is LoadMoreProgressState? Positioned(
                    bottom :16,
                    child: Container(
                        width: MediaQuery.of(context).size.width,
                        child: Center(child: CircularProgressIndicator(strokeWidth: 8,)))):Container(),
                // state.buttonAktivitas == true
                //   ? Positioned(
                //       bottom: 27,
                //       right: 17,
                //       child: GestureDetector(
                //         onTap: () => BlocProvider.of<NavigatorBloc>(context)
                //             .add(NavigateToAddAktivitasSalesPage(context, [widget.idPelanggan, widget.namaPelanggan, widget.dataKanban!.idPipelineMain])),
                //             // showDialogAddLayanan(context),
                //         child: Container(
                //           padding: EdgeInsets.all(13),
                //           decoration: BoxDecoration(
                //             shape: BoxShape.circle,
                //             color: CustomStyle.color1,
                //           ),
                //           child: Icon(Icons.add, color: Colors.white),
                //         ),
                //       ),
                //     ) : Container(),
              ],
            );


          }else{
            return Center(child: CircularProgressIndicator(strokeWidth: 8));
          }
        }
    );
  }
}
